/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.container;

import com.shoxie.audiocassettes.ModContainers;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.slots.TapeDeckCassetteSlot;
import com.shoxie.audiocassettes.slots.TapeDeckDiscSlot;
import com.shoxie.audiocassettes.tile.TapeDeckTile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TapeDeckContainer
extends Container {
    private TapeDeckTile tileEntity;
    private IItemHandler playerInventory;

    public TapeDeckContainer(int windowId, TapeDeckTile tile, PlayerInventory playerInventory) {
        super(ModContainers.CONTAINER_TAPE_DECK, windowId);
        this.tileEntity = tile;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            this.func_75146_a((Slot)new TapeDeckDiscSlot((IItemHandler)h, 0, 31, 32, tile));
            this.func_75146_a((Slot)new TapeDeckCassetteSlot((IItemHandler)h, 1, 125, 31, tile));
        });
        this.layoutPlayerInventorySlots(8, 84);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        this.tileEntity.stopWrite();
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 0 || index == 1) {
                if (!this.func_75135_a(stack, 2, 37, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (!this.func_75135_a(stack, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isWriting() {
        return this.tileEntity.isWriting();
    }

    public int getWriteTime(int p) {
        if (!((Slot)this.field_75151_b.get(1)).func_75216_d()) {
            return 0;
        }
        Item it = ((Slot)this.field_75151_b.get(1)).func_75211_c().func_77973_b();
        int i1 = this.tileEntity.getCurWriteTime();
        int i2 = 0;
        if (it instanceof AbstractAudioCassetteItem) {
            AbstractAudioCassetteItem c = (AbstractAudioCassetteItem)it;
            i2 = c.getMaxWriteTime();
        }
        return i2 > 0 && i1 > 0 ? i1 * p / i2 : 0;
    }

    public TapeDeckTile getTile() {
        return this.tileEntity;
    }

    public BlockPos getPos() {
        return this.tileEntity.func_174877_v();
    }
}

