/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.item;

import com.shoxie.audiocassettes.ModSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public abstract class AbstractAudioCassetteItem
extends Item {
    protected String name;
    protected int maxslots;
    protected int MaxWriteTime;

    public AbstractAudioCassetteItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            int k;
            boolean ldots;
            int song = AbstractAudioCassetteItem.getCurrentSlot(stack);
            int max = AbstractAudioCassetteItem.getMaxSlots(stack);
            boolean fdots = song > 3;
            boolean bl = ldots = song < max - 3;
            int n = song > 3 ? (song < max - 3 ? song - 3 : max - 6) : (k = 1);
            int j = song > 3 ? (song < max - 3 ? song + 3 : max) : 7;
            for (int i = k; i <= j; ++i) {
                if (!stack.func_77978_p().func_74764_b("Song" + i)) continue;
                if (i == k && fdots || i == j && ldots) {
                    tooltip.add(ForgeHooks.newChatWithLinks((String)"..."));
                    continue;
                }
                String str = stack.func_77978_p().func_74779_i("SongName" + i);
                if (str == "--Empty--") {
                    str = I18n.func_135052_a((String)"sound.audiocassettes.emptysound", (Object[])new Object[0]);
                }
                tooltip.add(ForgeHooks.newChatWithLinks((String)((i == song ? "\u2022 " : "") + i + ". " + str)));
            }
        }
    }

    public static void appendSongs(ItemStack stack, ResourceLocation res, String songname) {
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof AbstractAudioCassetteItem)) {
            return;
        }
        AbstractAudioCassetteItem c = (AbstractAudioCassetteItem)stack.func_77973_b();
        CompoundNBT nbt = new CompoundNBT();
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
        } else {
            nbt = new CompoundNBT();
            for (int i = 1; i <= c.maxslots; ++i) {
                nbt.func_74778_a("Song" + i, "audiocassettes:empty");
                nbt.func_74778_a("SongName" + i, "--Empty--");
            }
        }
        int curslot = AbstractAudioCassetteItem.getCurrentSlot(stack);
        nbt.func_74778_a("Song" + curslot, res.func_110624_b() + ":" + res.func_110623_a());
        nbt.func_74778_a("SongName" + curslot, songname);
        nbt.func_74768_a("ms", curslot);
        nbt.func_74768_a("max", c.maxslots);
        stack.func_77982_d(nbt);
    }

    public static SoundEvent getCurrentSong(ItemStack stack) {
        if (stack == null) {
            return ModSoundEvents.EMPTY;
        }
        if (!(stack.func_77973_b() instanceof AbstractAudioCassetteItem)) {
            return ModSoundEvents.EMPTY;
        }
        AbstractAudioCassetteItem c = (AbstractAudioCassetteItem)stack.func_77973_b();
        int ms = AbstractAudioCassetteItem.getCurrentSlot(stack);
        if (ms < 1 || ms > c.maxslots) {
            return ModSoundEvents.EMPTY;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt = stack.func_77978_p();
        return new SoundEvent(new ResourceLocation(nbt.func_74779_i("Song" + ms)));
    }

    public static int getMaxSlots(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (!(stack.func_77973_b() instanceof AbstractAudioCassetteItem)) {
            return 0;
        }
        AbstractAudioCassetteItem c = (AbstractAudioCassetteItem)stack.func_77973_b();
        return c.maxslots;
    }

    public static int getCurrentSlot(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (!(stack.func_77973_b() instanceof AbstractAudioCassetteItem)) {
            return 0;
        }
        CompoundNBT nbt = new CompoundNBT();
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
            return nbt.func_74762_e("ms");
        }
        return 0;
    }

    public int getMaxWriteTime() {
        return this.MaxWriteTime;
    }

    public static String getSongTitle(ItemStack stack) {
        if (stack == null) {
            return "--Empty--";
        }
        if (stack.func_77973_b() instanceof AbstractAudioCassetteItem) {
            AbstractAudioCassetteItem c = (AbstractAudioCassetteItem)stack.func_77973_b();
            int ms = AbstractAudioCassetteItem.getCurrentSlot(stack);
            if (ms < 1 || ms > c.maxslots) {
                return "--Empty--";
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt = stack.func_77978_p();
            return nbt.func_74779_i("SongName" + ms);
        }
        return "--Empty--";
    }

    public static void setActiveSlot(int song, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof AbstractAudioCassetteItem)) {
            return;
        }
        int newsong = 1;
        CompoundNBT nbt = new CompoundNBT();
        if (stack.func_77942_o()) {
            int maxsongs = 0;
            int cursong = 0;
            if (stack.func_77973_b() instanceof AbstractAudioCassetteItem) {
                cursong = AbstractAudioCassetteItem.getCurrentSlot(stack);
                maxsongs = AbstractAudioCassetteItem.getMaxSlots(stack);
            }
            if (maxsongs > 0 && song > 0 && song <= maxsongs) {
                newsong = song;
            } else if (song > maxsongs) {
                newsong = maxsongs;
            }
            if (cursong != newsong) {
                nbt = stack.func_77978_p();
                nbt.func_74768_a("ms", newsong);
                stack.func_77982_d(nbt);
            }
        }
    }

    public static int getNonEmptySlot(ItemStack c, boolean direction) {
        int cur = AbstractAudioCassetteItem.getCurrentSlot(c);
        int max = AbstractAudioCassetteItem.getMaxSlots(c);
        if (direction) {
            for (int i = cur = cur < max ? cur + 1 : cur; i <= max; ++i) {
                if (AbstractAudioCassetteItem.isSlotEmpty(i, c)) continue;
                return i;
            }
        } else {
            for (int i = cur = cur > 1 ? cur - 1 : cur; i >= 1; --i) {
                if (AbstractAudioCassetteItem.isSlotEmpty(i, c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isSlotEmpty(int i, ItemStack c) {
        if (c == null || c == ItemStack.field_190927_a || !c.func_77942_o()) {
            return true;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt = c.func_77978_p();
        return nbt.func_74779_i("Song" + i).equals("audiocassettes:empty");
    }
}

