/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.item;

import com.shoxie.audiocassettes.audiocassettes;
import com.shoxie.audiocassettes.capability.WalkmanCapability;
import com.shoxie.audiocassettes.container.WalkmanContainer;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.networking.Networking;
import com.shoxie.audiocassettes.networking.SWalkmanPlayPacket;
import com.shoxie.audiocassettes.networking.SWalkmanStopPacket;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class WalkmanItem
extends Item
implements INamedContainerProvider {
    private static String name = "walkman";

    public WalkmanItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName(name);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerentity) {
        return new WalkmanContainer(id, inventory, playerentity);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new WalkmanCapability();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemStack cassette = WalkmanItem.getCassette(stack);
        if (cassette.func_77973_b() instanceof AbstractAudioCassetteItem) {
            tooltip.add(ForgeHooks.newChatWithLinks((String)("Current Song: " + AbstractAudioCassetteItem.getCurrentSlot(cassette) + ". " + AbstractAudioCassetteItem.getSongTitle(cassette))));
        }
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> nbt.func_218657_a("walkman", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT(handler, null))));
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT(handler, null, nbt.func_74781_a("walkman")));
        }
    }

    public static void setTagBool(ItemStack mp, String name, boolean val) {
        if (mp.func_77973_b() instanceof WalkmanItem) {
            int intval = val ? 1 : 0;
            CompoundNBT nbt = mp.func_77942_o() ? mp.func_77978_p() : new CompoundNBT();
            nbt.func_74768_a(name, intval);
            mp.func_77982_d(nbt);
        }
    }

    public static void setPlaying(ItemStack stack, boolean val) {
        WalkmanItem.setTagBool(stack, "isPlaying", val);
    }

    public static boolean isPlaying(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74762_e("isPlaying") == 1) {
                return true;
            }
        } else {
            WalkmanItem.setPlaying(stack, false);
        }
        return false;
    }

    public static void setSong(int s, ItemStack c) {
        AbstractAudioCassetteItem.setActiveSlot(s, c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean switchSong(boolean forward, ItemStack cassette) {
        if (audiocassettes.skipemptyslots) {
            int song = AbstractAudioCassetteItem.getNonEmptySlot(cassette, forward);
            if (song == -1) return false;
            WalkmanItem.setSong(song, cassette);
            return true;
        } else {
            int cur = AbstractAudioCassetteItem.getCurrentSlot(cassette);
            int max = AbstractAudioCassetteItem.getMaxSlots(cassette);
            if (forward) {
                if (cur < max) {
                    WalkmanItem.setSong(cur + 1, cassette);
                    return true;
                } else {
                    if (cur <= max) return false;
                    WalkmanItem.setSong(max, cassette);
                }
                return true;
            } else if (cur > 1) {
                WalkmanItem.setSong(cur - 1, cassette);
                return true;
            } else {
                if (cur >= 1) return false;
                WalkmanItem.setSong(1, cassette);
            }
        }
        return true;
    }

    public static ItemStack getMPInHand(PlayerEntity player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack mp = player.func_184614_ca();
        if (!(mp.func_77973_b() instanceof WalkmanItem)) {
            mp = player.func_184592_cb();
        }
        return mp.func_77973_b() instanceof WalkmanItem ? mp : ItemStack.field_190927_a;
    }

    public static ItemStack getMPbyID(PlayerEntity p, String id) {
        if (p.field_71071_by.func_70445_o().func_77973_b() instanceof WalkmanItem && WalkmanItem.getID(p.field_71071_by.func_70445_o()).equals(id)) {
            return p.field_71071_by.func_70445_o();
        }
        for (Slot s : p.field_71069_bz.field_75151_b) {
            if (!s.func_75216_d() || !(s.func_75211_c().func_77973_b() instanceof WalkmanItem) || !WalkmanItem.getID(s.func_75211_c()).equals(id)) continue;
            return s.func_75211_c();
        }
        return ItemStack.field_190927_a;
    }

    public static void playMusic(ItemStack mp, ServerPlayerEntity sender) {
        List players = sender.func_71121_q().func_217369_A();
        WalkmanItem.setPlaying(mp, true);
        ItemStack cassette = WalkmanItem.getCassette(mp);
        if (cassette.func_77973_b() instanceof AbstractAudioCassetteItem) {
            for (ServerPlayerEntity player : players) {
                if (!(Math.abs(player.func_226277_ct_() - sender.func_226277_ct_()) < (double)audiocassettes.WalkmanMaxSoundDistance) || !(Math.abs(player.func_226278_cu_() - sender.func_226278_cu_()) < (double)audiocassettes.WalkmanMaxSoundDistance) || !(Math.abs(player.func_226281_cx_() - sender.func_226281_cx_()) < (double)audiocassettes.WalkmanMaxSoundDistance)) continue;
                Networking.INSTANCE.sendTo((Object)new SWalkmanPlayPacket(WalkmanItem.getID(mp), sender.func_110124_au().toString(), player == sender, cassette), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public static String getID(ItemStack mp) {
        if (mp.func_77973_b() instanceof WalkmanItem) {
            if (!mp.func_77942_o()) {
                CompoundNBT nbt = new CompoundNBT();
                Random rand = new Random();
                int randomNum = rand.nextInt(10000);
                nbt.func_74778_a("uid", Integer.toString(randomNum));
                mp.func_77982_d(nbt);
            }
            return mp.func_77978_p().func_74779_i("uid");
        }
        return null;
    }

    public static void stopMusic(String mpid, ServerPlayerEntity sender, boolean isdropped) {
        List players = sender.func_71121_q().func_217369_A();
        for (ServerPlayerEntity player : players) {
            Networking.INSTANCE.sendTo((Object)new SWalkmanStopPacket(mpid, player == sender ? !isdropped : false), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static ItemStack getCassette(ItemStack mp) {
        if (mp != null && mp.func_77973_b() instanceof WalkmanItem) {
            ItemStack[] it = new ItemStack[1];
            mp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                it[0] = h.getStackInSlot(0);
            });
            return it[0];
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isPlayerOwnMp(PlayerEntity p, String id) {
        List playerslots = p.field_71069_bz.field_75151_b;
        if (p.field_71071_by.func_70445_o().func_77973_b() instanceof WalkmanItem) {
            if (WalkmanItem.getID(p.field_71071_by.func_70445_o()).equals(id)) {
                return true;
            }
        } else {
            for (Slot s : playerslots) {
                if (!s.func_75216_d() || !(s.func_75211_c().func_77973_b() instanceof WalkmanItem) || !WalkmanItem.getID(s.func_75211_c()).equals(id)) continue;
                return true;
            }
        }
        return false;
    }
}

