/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.networking;

import com.shoxie.audiocassettes.tile.BoomBoxTile;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class BoomBoxNextSongPacket {
    private final BlockPos pos;
    private final boolean manually;

    public BoomBoxNextSongPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.manually = buf.readBoolean();
    }

    public BoomBoxNextSongPacket(BlockPos pos, boolean manually) {
        this.pos = pos;
        this.manually = manually;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.manually);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld sw = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            BoomBoxTile tile = (BoomBoxTile)sw.func_175625_s(this.pos);
            if (((NetworkEvent.Context)ctx.get()).getSender().func_110124_au().toString().equals(tile.owneruid) || this.manually) {
                boolean switched = tile.switchSong(true);
                if (this.manually) {
                    if (tile.isPlaying) {
                        tile.stopMusic();
                        tile.isPlaying = false;
                    }
                } else if (switched) {
                    tile.playMusic(((NetworkEvent.Context)ctx.get()).getSender());
                } else {
                    tile.stopMusic();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

