/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.networking;

import com.shoxie.audiocassettes.tile.TapeDeckTile;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class TapeDeckStartWritingPacket {
    private final BlockPos pos;
    private final ResourceLocation res;
    private final String sname;
    private final boolean erase;

    public TapeDeckStartWritingPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.res = buf.func_192575_l();
        this.sname = buf.func_150789_c(128);
        this.erase = buf.readBoolean();
    }

    public TapeDeckStartWritingPacket(BlockPos pos, ResourceLocation res, String sname, boolean erase) {
        this.pos = pos;
        this.res = res;
        this.sname = sname.length() > 127 ? "Untitled" : sname;
        this.erase = erase;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_192572_a(this.res);
        buf.func_180714_a(this.sname);
        buf.writeBoolean(this.erase);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld sw = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            TapeDeckTile tile = (TapeDeckTile)sw.func_175625_s(this.pos);
            tile.StartWrite(this.res, this.sname, this.erase);
        });
        ctx.get().setPacketHandled(true);
    }
}

