/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.tile;

import com.shoxie.audiocassettes.ModTileEntities;
import com.shoxie.audiocassettes.audiocassettes;
import com.shoxie.audiocassettes.container.BoomBoxContainer;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.networking.Networking;
import com.shoxie.audiocassettes.networking.SBoomBoxPlayPacket;
import com.shoxie.audiocassettes.networking.SBoomBoxStopPacket;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BoomBoxTile
extends TileEntity
implements INamedContainerProvider {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    public boolean isPlaying = false;
    public String id = "-";
    public String owneruid = "-";

    public BoomBoxTile() {
        super(ModTileEntities.TILE_BOOMBOX);
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BoomBoxContainer(i, this, playerInventory);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT tag) {
        CompoundNBT compound = tag.func_74775_l("cassette");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)compound));
        super.func_230337_a_(p_230337_1_, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("cassette", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        if (!this.field_145850_b.field_72995_K) {
            return new TranslationTextComponent("block.audiocassettes.boombox");
        }
        return null;
    }

    public void sendUpdates() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BoomBoxTile.this.func_70296_d();
            }
        };
    }

    public ItemStack getCassette() {
        ItemStack[] it = new ItemStack[1];
        this.handler.ifPresent(h -> {
            it[0] = h.getStackInSlot(0);
        });
        return it[0];
    }

    public void setSong(int song) {
        AbstractAudioCassetteItem.setActiveSlot(song, this.getCassette());
        this.sendUpdates();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean switchSong(boolean forward) {
        if (audiocassettes.skipemptyslots) {
            int song = AbstractAudioCassetteItem.getNonEmptySlot(this.getCassette(), forward);
            if (song == -1) return false;
            this.setSong(song);
        } else {
            int cur = AbstractAudioCassetteItem.getCurrentSlot(this.getCassette());
            int max = AbstractAudioCassetteItem.getMaxSlots(this.getCassette());
            if (forward) {
                if (cur < max) {
                    this.setSong(cur + 1);
                } else {
                    if (cur <= max) return false;
                    this.setSong(max);
                }
            } else if (cur > 1) {
                this.setSong(cur - 1);
            } else {
                if (cur >= 1) return false;
                this.setSong(1);
            }
        }
        this.sendUpdates();
        return true;
    }

    public void playMusic(ServerPlayerEntity sender) {
        List players = this.func_145831_w().func_73046_m().func_184103_al().func_181057_v();
        this.owneruid = sender.func_110124_au().toString();
        this.isPlaying = true;
        for (ServerPlayerEntity player : players) {
            if (!(Math.abs(player.func_226277_ct_() - (double)this.func_174877_v().func_177958_n()) < (double)audiocassettes.BoomBoxMaxSoundDistance) || !(Math.abs(player.func_226278_cu_() - (double)this.func_174877_v().func_177956_o()) < (double)audiocassettes.BoomBoxMaxSoundDistance) || !(Math.abs(player.func_226281_cx_() - (double)this.func_174877_v().func_177952_p()) < (double)audiocassettes.BoomBoxMaxSoundDistance)) continue;
            boolean isowner = player == sender;
            Networking.INSTANCE.sendTo((Object)new SBoomBoxPlayPacket(this.func_174877_v(), this.getID(), isowner, this.getCassette()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void stopMusic() {
        List players = this.func_145831_w().func_73046_m().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            Networking.INSTANCE.sendTo((Object)new SBoomBoxStopPacket(this.func_174877_v(), this.getID()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public String getID() {
        if (this.id.equals("-")) {
            Random rand = new Random();
            int randomNum = rand.nextInt(10000);
            this.id = Integer.toString(randomNum);
        }
        return this.id;
    }
}

