/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.item;

import com.shoxie.audiocassettes.audiocassettes;
import com.shoxie.audiocassettes.capability.WalkmanCapability;
import com.shoxie.audiocassettes.container.WalkmanContainer;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.networking.Networking;
import com.shoxie.audiocassettes.networking.SWalkmanPlayPacket;
import com.shoxie.audiocassettes.networking.SWalkmanStopPacket;
import com.shoxie.audiocassettes.networking.WalkmanOnDropPacket;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class WalkmanItem
extends Item
implements INamedContainerProvider {
    private static String name = "walkman";

    public WalkmanItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName(name);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean onDroppedByPlayer(ItemStack mp, PlayerEntity player) {
        Networking.INSTANCE.sendToServer((Object)new WalkmanOnDropPacket(mp));
        return true;
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerentity) {
        return new WalkmanContainer(id, inventory, playerentity);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new WalkmanCapability();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (WalkmanItem.getCassette(stack).func_77973_b() instanceof AbstractAudioCassetteItem) {
            tooltip.add(ForgeHooks.newChatWithLinks((String)("Current Song: " + AbstractAudioCassetteItem.getCurrentSlot(WalkmanItem.getCassette(stack)) + ". " + AbstractAudioCassetteItem.getSongTitle(WalkmanItem.getCassette(stack)))));
        }
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> nbt.func_218657_a("walkman", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT(handler, null))));
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT(handler, null, nbt.func_74781_a("walkman")));
        }
    }

    public static void setTagBool(ItemStack mp, String name, boolean val) {
        if (mp.func_77973_b() instanceof WalkmanItem) {
            int intval = val ? 1 : 0;
            CompoundNBT nbt = mp.func_77942_o() ? mp.func_77978_p() : new CompoundNBT();
            nbt.func_74768_a(name, intval);
            mp.func_77982_d(nbt);
        }
    }

    public static void setPlaying(ItemStack stack, boolean val) {
        WalkmanItem.setTagBool(stack, "isplaying", val);
    }

    public static void setLoop(ItemStack stack, boolean val) {
        WalkmanItem.setTagBool(stack, "isloop", val);
    }

    public static boolean IsPlaying(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74762_e("isplaying") == 1) {
                return true;
            }
        } else {
            WalkmanItem.setPlaying(stack, false);
        }
        return false;
    }

    public static boolean IsLoop(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74762_e("isloop") == 1) {
                return true;
            }
        } else {
            WalkmanItem.setLoop(stack, false);
        }
        return false;
    }

    public static ItemStack getMPInHand(PlayerEntity player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack mp = player.func_184614_ca();
        if (!(mp.func_77973_b() instanceof WalkmanItem)) {
            mp = player.func_184592_cb();
        }
        return mp.func_77973_b() instanceof WalkmanItem ? mp : ItemStack.field_190927_a;
    }

    public static ItemStack getMPbyID(PlayerEntity player, String id) {
        for (int i = 0; i < 36; ++i) {
            if (!(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof WalkmanItem) || !WalkmanItem.getID(player.field_71071_by.func_70301_a(i)).equals(id)) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public static void playMusic(ItemStack mp, ServerWorld sw, ServerPlayerEntity sender) {
        List players = sw.func_217369_A();
        WalkmanItem.setLoop(mp, true);
        for (ServerPlayerEntity player : players) {
            if (!(Math.abs(player.func_226277_ct_() - sender.func_226277_ct_()) < (double)audiocassettes.WalkmanMaxSoundDistance) || !(Math.abs(player.func_226278_cu_() - sender.func_226278_cu_()) < (double)audiocassettes.WalkmanMaxSoundDistance) || !(Math.abs(player.func_226281_cx_() - sender.func_226281_cx_()) < (double)audiocassettes.WalkmanMaxSoundDistance)) continue;
            Networking.INSTANCE.sendTo((Object)new SWalkmanPlayPacket(WalkmanItem.getID(mp), sender.func_110124_au().toString(), player == sender, WalkmanItem.getCassette(mp)), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static String getID(ItemStack mp) {
        if (mp.func_77973_b() instanceof WalkmanItem) {
            if (!mp.func_77942_o()) {
                CompoundNBT nbt = new CompoundNBT();
                Random rand = new Random();
                int randomNum = rand.nextInt(10000);
                nbt.func_74778_a("uid", Integer.toString(randomNum));
                mp.func_77982_d(nbt);
            }
            return mp.func_77978_p().func_74779_i("uid");
        }
        return null;
    }

    public static void stopMusic(ItemStack mp, ServerWorld sw, ServerPlayerEntity sender) {
        List players = sw.func_217369_A();
        for (ServerPlayerEntity player : players) {
            Networking.INSTANCE.sendTo((Object)new SWalkmanStopPacket(WalkmanItem.getID(mp), player == sender), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static ItemStack getCassette(ItemStack mp) {
        ItemStack[] it = new ItemStack[1];
        mp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            it[0] = h.getStackInSlot(0);
        });
        return it[0];
    }
}

