/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="audiocassettes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    private static ForgeConfigSpec.ConfigValue<Integer> walkmanmaxdist;
    private static ForgeConfigSpec.ConfigValue<Integer> boomboxbmaxdist;
    private static ForgeConfigSpec.ConfigValue<Boolean> nowplayingannounce;
    public static ForgeConfigSpec cfg;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    public static boolean isNowPlayingAnnounce() {
        return (Boolean)nowplayingannounce.get();
    }

    public static int getBoomBoxMaxDist() {
        return (Integer)boomboxbmaxdist.get();
    }

    public static int getWalkmanMaxDist() {
        return (Integer)walkmanmaxdist.get();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        nowplayingannounce = builder.comment(new String[]{"", "Announce the name of the song currently playing to everyone?"}).define("NowPlayingAnnounce", true);
        boomboxbmaxdist = builder.comment(new String[]{"", "Max distance for a BoomBox where you can hear music (works only with stereo music)"}).define("BoomBoxMaxDistance", (Object)64);
        walkmanmaxdist = builder.comment(new String[]{"", "Max distance for a Walkman where you can hear music (works only with stereo music)"}).define("WalkmanMaxDistance", (Object)28);
        builder.pop();
        cfg = builder.build();
    }
}

