/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes;

import com.shoxie.audiocassettes.ModBlocks;
import com.shoxie.audiocassettes.ModConfig;
import com.shoxie.audiocassettes.ModItems;
import com.shoxie.audiocassettes.ModSoundEvents;
import com.shoxie.audiocassettes.container.BoomBoxContainer;
import com.shoxie.audiocassettes.container.TapeDeckContainer;
import com.shoxie.audiocassettes.container.WalkmanContainer;
import com.shoxie.audiocassettes.networking.Networking;
import com.shoxie.audiocassettes.proxy.ClientProxy;
import com.shoxie.audiocassettes.proxy.IProxy;
import com.shoxie.audiocassettes.proxy.ServerProxy;
import com.shoxie.audiocassettes.tile.BoomBoxTile;
import com.shoxie.audiocassettes.tile.TapeDeckTile;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="audiocassettes")
public class audiocassettes {
    public static final String MODID = "audiocassettes";
    public static final String NAME = "Audio Cassettes";
    public static final String VERSION = "1.0";
    public static Logger logger = LogManager.getLogger((String)"audiocassettes");
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static final String EMPTY_SOUND = "empty";
    public static int WalkmanMaxSoundDistance = 28;
    public static int BoomBoxMaxSoundDistance = 64;
    public static boolean announceenabled = true;

    public audiocassettes() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RegistryEvents::ScreenInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RegistryEvents::NetworkingInit);
        ModConfig.loadConfig(ModConfig.cfg, FMLPaths.CONFIGDIR.get().resolve("audiocassettes-common.toml"));
        BoomBoxMaxSoundDistance = ModConfig.getBoomBoxMaxDist();
        WalkmanMaxSoundDistance = ModConfig.getWalkmanMaxDist();
        announceenabled = ModConfig.isNowPlayingAnnounce();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static void ScreenInit(FMLClientSetupEvent event) {
            proxy.ScreenInit();
        }

        public static void NetworkingInit(FMLCommonSetupEvent event) {
            Networking.registerMessages();
        }

        @SubscribeEvent
        public static void onSoundRegister(RegistryEvent.Register<SoundEvent> e) {
            e.getRegistry().register((IForgeRegistryEntry)ModSoundEvents.EMPTY);
        }

        @SubscribeEvent
        public static void onBlockRegister(RegistryEvent.Register<Block> e) {
            e.getRegistry().register((IForgeRegistryEntry)ModBlocks.TAPE_DECK);
            e.getRegistry().register((IForgeRegistryEntry)ModBlocks.BOOMBOX);
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> e) {
            e.getRegistry().register((IForgeRegistryEntry)ModItems.IRON_AUDIO_CASSETTE);
            e.getRegistry().register((IForgeRegistryEntry)ModItems.DIAMOND_AUDIO_CASSETTE);
            e.getRegistry().register((IForgeRegistryEntry)ModItems.GOLDEN_AUDIO_CASSETTE);
            e.getRegistry().register((IForgeRegistryEntry)ModItems.WALKMAN);
            e.getRegistry().register((IForgeRegistryEntry)ModItems.MAGNETIC_TAPE);
            e.getRegistry().register((IForgeRegistryEntry)ModItems.CASSETTE_FRAME);
            e.getRegistry().register(new BlockItem((Block)ModBlocks.TAPE_DECK, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(ModBlocks.TAPE_DECK.getRegistryName()));
            e.getRegistry().register(new BlockItem((Block)ModBlocks.BOOMBOX, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(ModBlocks.BOOMBOX.getRegistryName()));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(TapeDeckTile::new, (Block[])new Block[]{ModBlocks.TAPE_DECK}).func_206865_a(null).setRegistryName("tapedeck"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(BoomBoxTile::new, (Block[])new Block[]{ModBlocks.BOOMBOX}).func_206865_a(null).setRegistryName("boombox"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                TapeDeckTile tile = (TapeDeckTile)proxy.getClientWorld().func_175625_s(pos);
                return new TapeDeckContainer(windowId, tile, inv);
            }).setRegistryName("tapedeck"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                BoomBoxTile tile = (BoomBoxTile)proxy.getClientWorld().func_175625_s(pos);
                return new BoomBoxContainer(windowId, tile, inv);
            }).setRegistryName("boombox"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new WalkmanContainer(windowId, inv, proxy.getClientPlayer())).setRegistryName(new ResourceLocation(audiocassettes.MODID, "walkman")));
        }
    }
}

