/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.networking;

import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.item.WalkmanItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WalkmanNextSongPacket {
    private final String id;

    public WalkmanNextSongPacket(PacketBuffer buf) {
        this.id = buf.func_150789_c(16);
    }

    public WalkmanNextSongPacket(String id) {
        this.id = id;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.id);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int max;
            ItemStack mp = ItemStack.field_190927_a;
            if (this.id.equals("-")) {
                mp = WalkmanItem.getMPInHand((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                WalkmanItem.setPlaying(mp, false);
                WalkmanItem.stopMusic(mp, ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q(), ((NetworkEvent.Context)ctx.get()).getSender());
                WalkmanItem.setLoop(mp, false);
            } else {
                mp = WalkmanItem.getMPbyID((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.id);
            }
            if (mp == ItemStack.field_190927_a) {
                return;
            }
            ItemStack cassette = WalkmanItem.getCassette(mp);
            int song = AbstractAudioCassetteItem.getCurrentSlot(cassette);
            if (song < (max = AbstractAudioCassetteItem.getMaxSlots(cassette))) {
                AbstractAudioCassetteItem.setActiveSlot(song + 1, cassette);
            } else if (song > max) {
                AbstractAudioCassetteItem.setActiveSlot(max, cassette);
            }
            if (!this.id.equals("-") && song < max) {
                WalkmanItem.playMusic(mp, ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q(), ((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

