/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.tile;

import com.shoxie.audiocassettes.ModTileEntities;
import com.shoxie.audiocassettes.container.TapeDeckContainer;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TapeDeckTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int Slotscnt = 2;
    private boolean Started = false;
    private int WriteTime = 0;
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    ResourceLocation res;
    String sname;

    public TapeDeckTile() {
        super(ModTileEntities.TILE_TAPE_DECK);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TapeDeckContainer(i, this, playerInventory);
    }

    public void StartWrite(ResourceLocation res, String sname) {
        if (this.getItemInSlot(0).func_77973_b() instanceof MusicDiscItem && this.getItemInSlot(1).func_77973_b() instanceof AbstractAudioCassetteItem) {
            AbstractAudioCassetteItem c = (AbstractAudioCassetteItem)this.getItemInSlot(1).func_77973_b();
            this.WriteTime = c.getMaxWriteTime();
            this.Started = true;
            this.res = res;
            this.sname = sname;
        }
    }

    public int getCurWriteTime() {
        return this.WriteTime;
    }

    public int getSizeInventory() {
        return 2;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT tag) {
        CompoundNBT compound = tag.func_74775_l("inv");
        this.WriteTime = tag.func_74762_e("WriteTime");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)compound));
        super.func_230337_a_(p_230337_1_, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
            tag.func_74768_a("WriteTime", this.WriteTime);
        });
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.isWriting()) {
            --this.WriteTime;
            this.sendUpdates();
        } else if (!this.field_145850_b.field_72995_K) {
            ItemStack disc = this.getItemInSlot(0);
            ItemStack cassette = this.getItemInSlot(1);
            if (!disc.func_190926_b() && !cassette.func_190926_b() && disc.func_77973_b() instanceof MusicDiscItem && cassette.func_77973_b() instanceof AbstractAudioCassetteItem && this.Started) {
                this.FinaliseWrite(cassette);
            }
        }
    }

    private void FinaliseWrite(ItemStack cassette) {
        if (!(cassette.func_77973_b() instanceof AbstractAudioCassetteItem)) {
            return;
        }
        AbstractAudioCassetteItem.appendSongs(cassette, this.res, this.sname);
        this.Started = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        if (!this.field_145850_b.field_72995_K) {
            return new TranslationTextComponent("block.audiocassettes.tapedeck");
        }
        return null;
    }

    private ItemStack getItemInSlot(int itnum) {
        ItemStack[] it = new ItemStack[1];
        this.handler.ifPresent(h -> {
            it[0] = h.getStackInSlot(itnum);
        });
        return it[0];
    }

    public void sendUpdates() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                TapeDeckTile.this.func_70296_d();
            }
        };
    }

    public boolean isWriting() {
        return this.WriteTime > 0;
    }

    public void cancelWrite() {
        this.Started = false;
        this.WriteTime = 0;
        this.sendUpdates();
    }

    public void setSong(int song) {
        AbstractAudioCassetteItem.setActiveSlot(song, this.getItemInSlot(1));
        this.sendUpdates();
    }
}

