/*
 * Decompiled with CFR 0.152.
 */
package eliteasian.mods.banneradditions;

import eliteasian.mods.banneradditions.BannerAdditionsConfig;
import eliteasian.mods.banneradditions.BannerAdditionsRegistry;
import eliteasian.mods.banneradditions.banner.NewBannerTileEntityRenderer;
import eliteasian.mods.banneradditions.bannerpattern.BannerPatternTextureHandler;
import eliteasian.mods.banneradditions.bannerpattern.BannerPatterns;
import eliteasian.mods.banneradditions.loom.NewLoomScreen;
import eliteasian.mods.banneradditions.network.BannerPatternsMessage;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="banneradditions")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BannerAdditions {
    public static BannerAdditions INSTANCE;
    public static SimpleChannel SIMPLE_CHANNEL_INSTANCE;
    public static final String MOD_ID = "banneradditions";
    public static final Logger LOGGER;

    public BannerAdditions() {
        INSTANCE = this;
        FMLJavaModLoadingContext modLoader = FMLJavaModLoadingContext.get();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BannerAdditionsConfig.FORGE_SPEC, "banneradditions.toml");
        modLoader.getModEventBus().addListener(this::setup);
        modLoader.getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientConstructor();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientConstructor() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)BannerPatternTextureHandler.INSTANCE);
    }

    private void setup(FMLCommonSetupEvent event) {
        SIMPLE_CHANNEL_INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MOD_ID, "network"), () -> "1", i -> true, i -> true);
        SIMPLE_CHANNEL_INSTANCE.registerMessage(0, BannerPatternsMessage.class, BannerPatternsMessage::encode, BannerPatternsMessage::decode, BannerPatternsMessage::handle);
        try {
            Field f = PointOfInterestType.class.getDeclaredField(ASMAPI.mapField((String)"field_221073_u"));
            f.setAccessible(true);
            BannerAdditionsRegistry.Blocks.LOOM.func_176194_O().func_177619_a().forEach(s -> BannerAdditions.putBlockInPOI(f, s, PointOfInterestType.field_221066_n));
            BannerAdditionsRegistry.Blocks.CAULDRON.func_176194_O().func_177619_a().forEach(s -> BannerAdditions.putBlockInPOI(f, s, PointOfInterestType.field_221062_j));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static void putBlockInPOI(Field f, BlockState s, PointOfInterestType p) {
        try {
            ((Map)f.get(null)).put(s, p);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(BannerAdditionsRegistry.TileEntities.BANNER, NewBannerTileEntityRenderer::new);
        ScreenManager.func_216911_a(BannerAdditionsRegistry.Containers.LOOM, NewLoomScreen::new);
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager resourceManager = event.getServer().func_195570_aG();
        resourceManager.func_219534_a((IFutureReloadListener)new BannerPatterns());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BannerAdditionsRegistry.Blocks.registerAllBlocks(event);
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        BannerAdditionsRegistry.TileEntities.registerAllTileEntities(event);
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        BannerAdditionsRegistry.Containers.registerAllContainers(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BannerAdditionsRegistry.Items.registerAllItems(event);
    }

    @SubscribeEvent
    public static void registerCraftingRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        BannerAdditionsRegistry.CraftingRecipes.registerAllRecipes(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        block3: {
            block2: {
                if (!event.getMap().func_229223_g_().equals((Object)new ResourceLocation("minecraft:textures/atlas/banner_patterns.png"))) break block2;
                for (ResourceLocation i : BannerPatternTextureHandler.bannerTextures) {
                    event.addSprite(i);
                }
                break block3;
            }
            if (!event.getMap().func_229223_g_().equals((Object)new ResourceLocation("minecraft:textures/atlas/shield_patterns.png"))) break block3;
            for (ResourceLocation i : BannerPatternTextureHandler.shieldTextures) {
                event.addSprite(i);
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

