/*
 * Decompiled with CFR 0.152.
 */
package eliteasian.mods.banneradditions.bannerpattern;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import eliteasian.mods.banneradditions.BannerAdditions;
import eliteasian.mods.banneradditions.BannerAdditionsConfig;
import eliteasian.mods.banneradditions.BannerAdditionsRegistry;
import eliteasian.mods.banneradditions.bannerpattern.BannerPatternHolder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class BannerPatterns
implements IResourceManagerReloadListener {
    private static final List<BannerPatternHolder> bannerPatterns = new ArrayList<BannerPatternHolder>();
    private static final Gson GSON = new Gson();

    public void func_195410_a(IResourceManager resourceManagerIn) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        for (ResourceLocation resourceLocation : resourceManagerIn.func_199003_a("banner_patterns", i -> i.endsWith(".json"))) {
            try {
                IResource resource = resourceManagerIn.func_199002_a(resourceLocation);
                Throwable throwable = null;
                try {
                    InputStreamReader reader = new InputStreamReader(resource.func_199027_b());
                    ResourceLocation newResourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a().substring(0, resourceLocation.func_110623_a().length() - 5));
                    map.put(newResourceLocation, (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (Exception e) {
                BannerAdditions.LOGGER.error("Error loading Banner Pattern " + resourceLocation, (Throwable)e);
            }
        }
        this.apply(map, resourceManagerIn);
    }

    private void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn) {
        BannerPatterns.clear();
        BannerPatterns.regStatic("base", "b");
        BannerPatterns.regStatic("square_bottom_left", "bl");
        BannerPatterns.regStatic("square_bottom_right", "br");
        BannerPatterns.regStatic("square_top_left", "tl");
        BannerPatterns.regStatic("square_top_right", "tr");
        BannerPatterns.regStatic("stripe_bottom", "bs");
        BannerPatterns.regStatic("stripe_top", "ts");
        BannerPatterns.regStatic("stripe_left", "ls");
        BannerPatterns.regStatic("stripe_right", "rs");
        BannerPatterns.regStatic("stripe_center", "cs");
        BannerPatterns.regStatic("stripe_middle", "ms");
        BannerPatterns.regStatic("stripe_downright", "drs");
        BannerPatterns.regStatic("stripe_downleft", "dls");
        BannerPatterns.regStatic("small_stripes", "ss");
        BannerPatterns.regStatic("cross", "cr");
        BannerPatterns.regStatic("straight_cross", "sc");
        BannerPatterns.regStatic("triangle_bottom", "bt");
        BannerPatterns.regStatic("triangle_top", "tt");
        BannerPatterns.regStatic("triangles_bottom", "bts");
        BannerPatterns.regStatic("triangles_top", "tts");
        BannerPatterns.regStatic("diagonal_left", "ld");
        BannerPatterns.regStatic("diagonal_up_right", "rd");
        BannerPatterns.regStatic("diagonal_up_left", "lud");
        BannerPatterns.regStatic("diagonal_right", "rud");
        BannerPatterns.regStatic("circle", "mc");
        BannerPatterns.regStatic("rhombus", "mr");
        BannerPatterns.regStatic("half_vertical", "vh");
        BannerPatterns.regStatic("half_horizontal", "hh");
        BannerPatterns.regStatic("half_vertical_right", "vhr");
        BannerPatterns.regStatic("half_horizontal_bottom", "hhb");
        BannerPatterns.regStatic("border", "bo");
        BannerPatterns.regStatic("curly_border", "cbo");
        BannerPatterns.regStatic("gradient", "gra");
        BannerPatterns.regStatic("gradient_up", "gru");
        BannerPatterns.regStatic("bricks", "bri");
        BannerPatterns.regStatic("globe", "glb", BannerAdditionsRegistry.Items.GLOBE_BANNER_PATTERN);
        BannerPatterns.regStatic("creeper", "cre", BannerAdditionsRegistry.Items.CREEPER_BANNER_PATTERN);
        BannerPatterns.regStatic("skull", "sku", BannerAdditionsRegistry.Items.SKULL_BANNER_PATTERN);
        BannerPatterns.regStatic("flower", "flo", BannerAdditionsRegistry.Items.FLOWER_BANNER_PATTERN);
        BannerPatterns.regStatic("mojang", "moj", BannerAdditionsRegistry.Items.MOJANG_BANNER_PATTERN);
        BannerPatterns.regStatic("piglin", "pig", BannerAdditionsRegistry.Items.PIGLIN_BANNER_PATTERN);
        if (!((Boolean)BannerAdditionsConfig.CONFIG.safeMode.get()).booleanValue()) {
            for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
                ResourceLocation resourceLocation = entry.getKey();
                if (resourceLocation.func_110623_a().startsWith("_")) continue;
                JsonObject json = JSONUtils.func_151210_l((JsonElement)entry.getValue(), (String)"top element");
                String hashname = JSONUtils.func_151200_h((JsonObject)json, (String)"hashname");
                ResourceLocation bannerTextureRaw = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"bannerTexture"));
                ResourceLocation shieldTextureRaw = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"shieldTexture"));
                ResourceLocation bannerTexture = new ResourceLocation(bannerTextureRaw.func_110624_b(), "entity/banner/" + bannerTextureRaw.func_110623_a());
                ResourceLocation shieldTexture = new ResourceLocation(shieldTextureRaw.func_110624_b(), "entity/shield/" + shieldTextureRaw.func_110623_a());
                String[] pathSplit = resourceLocation.func_110623_a().split("/");
                String name = pathSplit[pathSplit.length - 1];
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"item")) {
                    ResourceLocation item = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"item"));
                    BannerPatterns.add(new BannerPatternHolder(bannerTexture, shieldTexture, hashname, name, item));
                    continue;
                }
                BannerPatterns.add(new BannerPatternHolder(bannerTexture, shieldTexture, hashname, name));
            }
        }
    }

    public static void regStatic(String name, String hashname, Item item) {
        bannerPatterns.add(new BannerPatternHolder(new ResourceLocation("minecraft", "entity/banner/" + name), new ResourceLocation("minecraft", "entity/shield/" + name), hashname, name, item.getRegistryName()));
    }

    public static void regStatic(String name, String hashname) {
        BannerPatterns.regStatic(name, hashname, Items.field_190931_a);
    }

    public static void add(BannerPatternHolder bannerPatternHolder) {
        bannerPatterns.add(bannerPatternHolder);
    }

    public static void clear() {
        bannerPatterns.clear();
    }

    public static BannerPatternHolder get(int i) {
        return bannerPatterns.get(i);
    }

    public static BannerPatternHolder get(String hash) {
        for (BannerPatternHolder i : bannerPatterns) {
            if (!i.getHashname().equals(hash)) continue;
            return i;
        }
        return null;
    }

    public static int getLength() {
        return bannerPatterns.size();
    }

    public static ListNBT toListNBT(Pair<BannerPatternHolder, DyeColor> ... patterns) {
        ListNBT listnbt = new ListNBT();
        for (Pair<BannerPatternHolder, DyeColor> pair : patterns) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("Pattern", ((BannerPatternHolder)pair.getFirst()).getHashname());
            compoundnbt.func_74768_a("Color", ((DyeColor)pair.getSecond()).func_196059_a());
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    public static BannerPatternHolder[] getWithItem(Item item) {
        Item usingItem = item;
        if (usingItem == null) {
            usingItem = Items.field_190931_a;
        }
        ArrayList<BannerPatternHolder> out = new ArrayList<BannerPatternHolder>();
        for (BannerPatternHolder pattern : bannerPatterns) {
            if (!pattern.getItem().equals((Object)usingItem.getRegistryName())) continue;
            out.add(pattern);
        }
        return out.toArray(new BannerPatternHolder[0]);
    }

    public static List<BannerPatternHolder> getAsList() {
        return new ArrayList<BannerPatternHolder>(bannerPatterns);
    }
}

