/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.charm;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.charm.ClientCharmedMob;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.duration.DurationRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;

public class ClientCharmedMobsRepository
implements CharmedMobsRepository {
    public static final String NAME = ClientCharmedMobsRepository.class.getSimpleName();
    Consumer<String> cRemovalCallback = id -> this.remove((String)id);
    Map<String, CharmedMob> charmedMobs = new ConcurrentHashMap<String, CharmedMob>();

    @Override
    public void add(MobEntity entity, LivingEntity commander) {
        int duration = (Integer)ModConfiguration.charmDuration.get();
        ClientCharmedMob charmedMob = ClientCharmedMob.getInstance(entity, duration);
        if (this.contains(charmedMob.getId())) {
            return;
        }
        DurationRepository repository = BassebombeCraft.getProxy().getClientDurationRepository();
        repository.add(charmedMob.getId(), duration, this.cRemovalCallback);
        this.charmedMobs.put(charmedMob.getId(), charmedMob);
    }

    @Override
    public void remove(String id) {
        if (!this.contains(id)) {
            return;
        }
        this.charmedMobs.remove(id);
    }

    @Override
    public void remove(MobEntity entity) {
        int id = entity.func_145782_y();
        String idAsString = Integer.toString(id);
        this.remove(idAsString);
    }

    @Override
    public boolean contains(String id) {
        return this.charmedMobs.containsKey(id);
    }

    @Override
    public boolean contains(MobEntity entity) {
        int id = entity.func_145782_y();
        String idAsString = Integer.toString(id);
        return this.charmedMobs.containsKey(idAsString);
    }

    @Override
    public Stream<CharmedMob> get() {
        return this.charmedMobs.values().stream();
    }

    @Override
    public int size() {
        return this.charmedMobs.size();
    }

    public static CharmedMobsRepository getInstance() {
        return new ClientCharmedMobsRepository();
    }
}

