/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ClientModConstants;
import bassebombecraft.client.operator.ClientPorts;
import bassebombecraft.client.operator.DefaultClientPorts;
import bassebombecraft.client.operator.rendering.RenderTextBillboard2;
import bassebombecraft.client.operator.rendering.RenderWireframeBoundingBox2;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.client.rendering.rendertype.RenderTypes;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.operator.Sequence2;
import bassebombecraft.player.PlayerUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawHighlightEvent;

public class BuildMineBookRenderer {
    static final float AABB_OSCILLIATION = 0.025f;
    static final float TEXT_OSCILLIATION = 25.0f;
    static Supplier<Operator2> splOp = () -> new Sequence2(new RenderWireframeBoundingBox2(0.025f, ClientModConstants.HUD_LINE_COLOR, RenderTypes.OVERLAY_LINES), new RenderTextBillboard2(DefaultPorts.getFnGetString1(), -5, -20, 25.0f, 0xC0C000));

    public static void handleHighlightBlockEvent(DrawHighlightEvent.HighlightBlock event) {
        try {
            if (!ClientPlayerUtils.isClientSidePlayerDefined()) {
                return;
            }
            PlayerEntity player = ClientPlayerUtils.getClientSidePlayer();
            if (!PlayerUtils.isItemHeldInEitherHands(player, (Item)RegisteredItems.MINE_BOOK.get())) {
                return;
            }
            BuildMineBookRenderer.render(event, player);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void render(DrawHighlightEvent.HighlightBlock event, PlayerEntity player) {
        BlockRayTraceResult result = event.getTarget();
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos blockPos = result.func_216350_a();
        AxisAlignedBB aabb = new AxisAlignedBB(blockPos);
        Direction direction = result.func_216354_b();
        String message = "N/A";
        switch (direction) {
            case UP: {
                message = "> Click on a GROUND block to excavate ENTRACE";
                break;
            }
            case DOWN: {
                break;
            }
            case EAST: 
            case NORTH: 
            case SOUTH: 
            case WEST: {
                message = "> Click on a WALL block to excavate ROOM";
                break;
            }
        }
        ClientPorts ports = DefaultClientPorts.getInstance();
        ports.setAabb1(aabb);
        ports.setMatrixStack1(event.getMatrix());
        ports.setString1(message);
        Operators2.run((Ports)ports, splOp.get());
    }
}

