/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.client.rendering.RenderingUtils;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.commander.MobCommand;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.player.PlayerUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class TeamInfoRenderer {
    public static void handleRenderWorldLastEvent(RenderWorldLastEvent event) {
        try {
            if (!ClientPlayerUtils.isClientSidePlayerDefined()) {
                return;
            }
            PlayerEntity player = ClientPlayerUtils.getClientSidePlayer();
            if (!PlayerUtils.isItemInHotbar(player, (Item)RegisteredItems.HUD.get())) {
                return;
            }
            TeamInfoRenderer.render(event.getMatrixStack(), player);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void render(MatrixStack matrixStack, PlayerEntity player) {
        TeamRepository repository = BassebombeCraft.getProxy().getServerTeamRepository();
        Collection<LivingEntity> team = repository.get(player);
        int teamSize = repository.size(player);
        MobCommanderRepository commanderRepository = BassebombeCraft.getProxy().getServerMobCommanderRepository();
        MobCommand command = commanderRepository.getCommand((LivingEntity)player);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, -210.0f, -110.0f, "TEAM");
        RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, -210.0f, -100.0f, "Commander command: " + command.getTitle());
        RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, -210.0f, -90.0f, "Team size: " + teamSize);
        AtomicInteger count = new AtomicInteger();
        team.forEach(m -> {
            int counter = count.incrementAndGet();
            if (counter > 7) {
                return;
            }
            String memberName = m.func_200200_C_().func_150261_e();
            String targetName = TeamInfoRenderer.getTargetName(m);
            String text = "Member: " + memberName + ", Target: " + targetName;
            RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, -210.0f, -80 + counter * 10, text);
        });
    }

    static String getTargetName(LivingEntity entity) {
        if (!EntityUtils.hasAliveTarget(entity)) {
            return "N/A";
        }
        LivingEntity target = EntityUtils.getTarget(entity);
        return target.func_200200_C_().func_150261_e();
    }
}

