/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering.particle;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.particle.ParticleRenderingRepository;
import bassebombecraft.event.particle.ParticleRendering;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class DefaultParticleRenderingRepository
implements ParticleRenderingRepository {
    Consumer<String> cRemovalCallback = id -> this.remove((String)id);
    ConcurrentHashMap<String, ParticleRendering> particles = new ConcurrentHashMap();

    @Override
    public void add(String id, ParticleRendering particle) {
        try {
            if (this.particles.containsKey(id)) {
                return;
            }
            int duration = this.resolveSpawnDuration(particle.getInfo().getDuration());
            BassebombeCraft.getProxy().getClientDurationRepository().add(id, duration, this.cRemovalCallback);
            this.particles.put(id, particle);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    int resolveSpawnDuration(int duration) {
        if (duration < 0) {
            return -1;
        }
        return 2;
    }

    @Override
    public void remove(String id) {
        try {
            this.particles.remove(id);
            BassebombeCraft.getProxy().getClientDurationRepository().remove(id);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @Override
    public Stream<ParticleRendering> get() {
        return this.particles.values().stream();
    }

    public static ParticleRenderingRepository getInstance() {
        return new DefaultParticleRenderingRepository();
    }
}

