/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering.particle;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.particle.ParticleRenderingRepository;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.event.particle.ParticleRendering;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class ParticleRenderer {
    public static void handleRenderWorldLastEvent(RenderWorldLastEvent event) {
        try {
            if (!ClientPlayerUtils.isClientSidePlayerDefined()) {
                return;
            }
            PlayerEntity player = ClientPlayerUtils.getClientSidePlayer();
            World world = player.func_130014_f_();
            ParticleRenderer.render(world);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void render(World world) throws Exception {
        ParticleRenderingRepository repository = BassebombeCraft.getProxy().getClientParticleRenderingRepository();
        Stream<ParticleRendering> particles = repository.get();
        particles.forEach(p -> {
            int numberToRender = p.getNumber();
            for (int i = 0; i < numberToRender; ++i) {
                if (ParticleRenderer.renderWithCustomColor(p)) {
                    ParticleRenderer.renderParticleWithCustomColor(world, p);
                    continue;
                }
                ParticleRenderer.renderParticle(world, p);
            }
        });
    }

    static boolean renderWithCustomColor(ParticleRendering particle) {
        BasicParticleType type = particle.getParticleType();
        return type == ParticleTypes.field_197620_m;
    }

    static void renderParticle(World world, ParticleRendering particle) {
        double speed = particle.getInfo().getSpeed();
        double d0 = ParticleRenderer.calculateRandomSpeed(speed);
        double d1 = ParticleRenderer.calculateRandomSpeed(speed);
        double d2 = ParticleRenderer.calculateRandomSpeed(speed);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = (double)particle.getPosition().func_177956_o() + 1.0;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        Minecraft mcClient = Minecraft.func_71410_x();
        ParticleManager manager = mcClient.field_71452_i;
        Particle spellParticle = manager.func_199280_a((IParticleData)particle.getParticleType(), x, y, z, d0, d1, d2);
        int duration = Math.abs(particle.getInfo().getDuration());
        spellParticle.func_187114_a(duration);
    }

    static void renderParticleWithCustomColor(World world, ParticleRendering particle) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        double speed = particle.getInfo().getSpeed();
        double d0 = ParticleRenderer.calculateRandomSpeed(speed);
        double d1 = ParticleRenderer.calculateRandomSpeed(speed);
        double d2 = ParticleRenderer.calculateRandomSpeed(speed);
        float r = particle.getRedColorComponent(random);
        float g = particle.getGreenColorComponent(random);
        float b = particle.getBlueColorComponent(random);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = (double)particle.getPosition().func_177956_o() + 1.0;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        Minecraft mcClient = Minecraft.func_71410_x();
        ParticleManager manager = mcClient.field_71452_i;
        Particle spellParticle = manager.func_199280_a((IParticleData)ParticleTypes.field_197620_m, x, y, z, d0, d1, d2);
        spellParticle.func_70538_b(r, g, b);
        int duration = Math.abs(particle.getInfo().getDuration());
        spellParticle.func_187114_a(duration);
    }

    static double calculateRandomSpeed(double speed) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        return (random.nextDouble() * 2.0 - 1.0) * speed;
    }
}

