/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.operator.rendering;

import bassebombecraft.ClientModConstants;
import bassebombecraft.client.operator.ClientOperators2;
import bassebombecraft.client.operator.ClientPorts;
import bassebombecraft.client.operator.DefaultClientPorts;
import bassebombecraft.client.rendering.rendertype.RenderTypes;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class RenderWireframeBoundingBox2
implements Operator2 {
    Function<Ports, AxisAlignedBB> fnGetAabb;
    Function<ClientPorts, MatrixStack> fnGetMatrixStack;
    float oscillateMax;
    Vector4f color;
    RenderType renderType;

    public RenderWireframeBoundingBox2() {
        this.fnGetAabb = DefaultPorts.getFnAabb1();
        this.fnGetMatrixStack = DefaultClientPorts.getFnMaxtrixStack1();
        this.oscillateMax = 0.02f;
        this.color = ClientModConstants.DEFAULT_LINE_COLOR;
        this.renderType = RenderTypes.DEFAULT_LINES;
    }

    public RenderWireframeBoundingBox2(float oscillateMax, Vector4f color, RenderType renderType) {
        this();
        this.oscillateMax = oscillateMax;
        this.color = color;
        this.renderType = renderType;
    }

    public RenderWireframeBoundingBox2(Function<Ports, AxisAlignedBB> fnGetAabb, float oscillateMax, Vector4f color, RenderType renderType) {
        this.fnGetAabb = fnGetAabb;
        this.fnGetMatrixStack = DefaultClientPorts.getFnMaxtrixStack1();
        this.oscillateMax = oscillateMax;
        this.color = color;
        this.renderType = renderType;
    }

    @Override
    public void run(Ports ports) {
        AxisAlignedBB aabb = Operators2.applyV(this.fnGetAabb, ports);
        MatrixStack matrixStack = ClientOperators2.clientApplyV(this.fnGetMatrixStack, ports);
        Minecraft mcClient = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mcClient.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(this.renderType);
        matrixStack.func_227860_a_();
        Vec3d projectedView = mcClient.field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        aabb = aabb.func_186662_g(GeometryUtils.oscillate(0.0f, this.oscillateMax));
        this.renderWireframeBox(aabb, builder, positionMatrix);
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(this.renderType);
    }

    void renderWireframeBox(AxisAlignedBB aabb, IVertexBuilder builder, Matrix4f positionMatrix) {
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
        this.addVertex(builder, positionMatrix, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
    }

    void addVertex(IVertexBuilder builder, Matrix4f positionMatrix, float x, float y, float z) {
        builder.func_227888_a_(positionMatrix, x, y, z).func_227885_a_(this.color.func_195910_a(), this.color.func_195913_b(), this.color.func_195914_c(), this.color.func_195915_d()).func_181675_d();
    }

    void addVertex(IVertexBuilder builder, Matrix4f positionMatrix, double x, double y, double z) {
        this.addVertex(builder, positionMatrix, (float)x, (float)y, (float)z);
    }
}

