/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.proxy;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.charm.ClientCharmedMobsRepository;
import bassebombecraft.client.event.rendering.BuildMineBookRenderer;
import bassebombecraft.client.event.rendering.DecoyRenderer;
import bassebombecraft.client.event.rendering.DecreaseSizeEffectRenderer;
import bassebombecraft.client.event.rendering.HudItemCharmedInfoRenderer;
import bassebombecraft.client.event.rendering.HudItemHighlightedBlockRenderer;
import bassebombecraft.client.event.rendering.IncreaseSizeEffectRenderer;
import bassebombecraft.client.event.rendering.RenderingEventHandler;
import bassebombecraft.client.event.rendering.RespawnedRenderer;
import bassebombecraft.client.event.rendering.effect.ClientGraphicalEffectRepository;
import bassebombecraft.client.event.rendering.effect.EffectRenderer;
import bassebombecraft.client.event.rendering.effect.GraphicalEffectRepository;
import bassebombecraft.client.event.rendering.particle.DefaultParticleRenderingRepository;
import bassebombecraft.client.event.rendering.particle.ParticleRenderer;
import bassebombecraft.client.event.rendering.particle.ParticleRenderingRepository;
import bassebombecraft.client.particles.RegisteredParticles;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.client.rendering.entity.CircleProjectileEntityRenderer;
import bassebombecraft.client.rendering.entity.EggProjectileEntityRenderer;
import bassebombecraft.client.rendering.entity.LightningProjectileEntityRenderer;
import bassebombecraft.client.rendering.entity.LlamaProjectileEntityRenderer;
import bassebombecraft.client.rendering.entity.SkullProjectileEntityRenderer;
import bassebombecraft.client.screen.CompositeMagicItemScreen;
import bassebombecraft.config.VersionUtils;
import bassebombecraft.entity.commander.DefaultMobCommanderRepository;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.block.DefaultBlockDirectiveRepository;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlockRepository;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.charm.ServerCharmedMobsRepository;
import bassebombecraft.event.duration.DefaultDurationRepository;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.event.entity.target.DefaultTargetRepository;
import bassebombecraft.event.entity.target.TargetRepository;
import bassebombecraft.event.entity.team.DefaultTeamRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.event.frequency.DefaultFrequencyRepository;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.job.DefaultJobReposiory;
import bassebombecraft.event.job.JobRepository;
import bassebombecraft.event.projectile.RegisteredEntityTypes;
import bassebombecraft.inventory.container.RegisteredContainers;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.network.NetworkChannelHelper;
import bassebombecraft.proxy.Proxy;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.apache.logging.log4j.Logger;

public class ClientProxy
implements Proxy {
    static final int META = 0;
    FrequencyRepository clientFrequencyRepository = DefaultFrequencyRepository.getInstance();
    FrequencyRepository serverFrequencyRepository = DefaultFrequencyRepository.getInstance();
    DurationRepository clientDurationRepository = DefaultDurationRepository.getInstance();
    DurationRepository serverDurationRepository = DefaultDurationRepository.getInstance();
    JobRepository jobRepository = DefaultJobReposiory.getInstance();
    ParticleRenderingRepository particleRepository = DefaultParticleRenderingRepository.getInstance();
    GraphicalEffectRepository graphicalEffectRepository = ClientGraphicalEffectRepository.getInstance();
    CharmedMobsRepository clientCharmedMobsRepository = ClientCharmedMobsRepository.getInstance();
    CharmedMobsRepository serverCharmedMobsRepository = ServerCharmedMobsRepository.getInstance();
    BlockDirectivesRepository blockDirectivesRepository = DefaultBlockDirectiveRepository.getInstance();
    TemporaryBlockRepository tempBlockRepository = DefaultTemporaryBlockRepository.getInstance();
    MobCommanderRepository mobCommanderRepository = DefaultMobCommanderRepository.getInstance();
    TeamRepository teamRepository = DefaultTeamRepository.getInstance();
    TargetRepository targetRepository = DefaultTargetRepository.getInstance();
    NetworkChannelHelper networkHelper = new NetworkChannelHelper();

    @Override
    public void startAnalyticsSession() {
        try {
            VersionUtils.startSession(this.getUser());
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Initiating usage session failed with: " + ex.getMessage());
        }
    }

    @Override
    public void endAnalyticsSession() {
        try {
            VersionUtils.endSession(this.getUser());
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Initiating usage session failed with: " + ex.getMessage());
        }
    }

    @Override
    public void postItemUsage(String itemName, String user) {
        try {
            VersionUtils.postItemUsageEvent(user, itemName);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting usage failed with: " + ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public void postException(Throwable e) {
        try {
            VersionUtils.postException(this.getUser(), e);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting exception:" + e + " failed with: " + ex);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for original exception:" + sw);
            sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public void postError(String msg) {
        try {
            VersionUtils.postError(this.getUser(), msg);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting error:" + msg + " failed with: " + ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public void postAiObservation(String type, String observation) {
        try {
            VersionUtils.postAiObservation(this.getUser(), type, observation);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting AI observation: failed with: " + ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public String getUser() {
        return ClientPlayerUtils.getClientSidePlayerUId();
    }

    @Override
    public void setupClientSideRendering() throws UnsupportedOperationException {
        MinecraftForge.EVENT_BUS.addListener(RenderingEventHandler::handleRenderWorldLastEvent);
        MinecraftForge.EVENT_BUS.addListener(HudItemCharmedInfoRenderer::handleRenderWorldLastEvent);
        MinecraftForge.EVENT_BUS.addListener(HudItemHighlightedBlockRenderer::handleHighlightBlockEvent);
        MinecraftForge.EVENT_BUS.addListener(BuildMineBookRenderer::handleHighlightBlockEvent);
        MinecraftForge.EVENT_BUS.addListener(DecreaseSizeEffectRenderer::handleRenderLivingEventPre);
        MinecraftForge.EVENT_BUS.addListener(DecreaseSizeEffectRenderer::handleRenderLivingEventPost);
        MinecraftForge.EVENT_BUS.addListener(IncreaseSizeEffectRenderer::handleRenderLivingEventPre);
        MinecraftForge.EVENT_BUS.addListener(IncreaseSizeEffectRenderer::handleRenderLivingEventPost);
        MinecraftForge.EVENT_BUS.addListener(DecoyRenderer::handleRenderLivingEventPre);
        MinecraftForge.EVENT_BUS.addListener(DecoyRenderer::handleRenderLivingEventPost);
        MinecraftForge.EVENT_BUS.addListener(RespawnedRenderer::handleRenderLivingEventPre);
        MinecraftForge.EVENT_BUS.addListener(RespawnedRenderer::handleRenderLivingEventPost);
        MinecraftForge.EVENT_BUS.addListener(ParticleRenderer::handleRenderWorldLastEvent);
        MinecraftForge.EVENT_BUS.addListener(EffectRenderer::handleRenderWorldLastEvent);
        RenderingRegistry.registerEntityRenderingHandler(RegisteredEntityTypes.EGG_PROJECTILE, EggProjectileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegisteredEntityTypes.LLAMA_PROJECTILE, LlamaProjectileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegisteredEntityTypes.LIGHTNING_PROJECTILE, LightningProjectileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegisteredEntityTypes.CIRCLE_PROJECTILE, CircleProjectileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegisteredEntityTypes.SKULL_PROJECTILE, SkullProjectileEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)RegisteredContainers.COMPOSITE_ITEM_COMTAINER.get()), CompositeMagicItemScreen::new);
    }

    @Override
    public NetworkChannelHelper getNetworkChannel() {
        return this.networkHelper;
    }

    @Override
    public FrequencyRepository getServerFrequencyRepository() throws UnsupportedOperationException {
        return this.serverFrequencyRepository;
    }

    @Override
    public FrequencyRepository getClientFrequencyRepository() throws UnsupportedOperationException {
        return this.clientFrequencyRepository;
    }

    @Override
    public DurationRepository getServerDurationRepository() {
        return this.serverDurationRepository;
    }

    @Override
    public DurationRepository getClientDurationRepository() throws UnsupportedOperationException {
        return this.clientDurationRepository;
    }

    @Override
    public JobRepository getServerJobRepository() {
        return this.jobRepository;
    }

    @Override
    public ParticleRenderingRepository getClientParticleRenderingRepository() throws UnsupportedOperationException {
        return this.particleRepository;
    }

    @Override
    public GraphicalEffectRepository getClientGraphicalEffectRepository() throws UnsupportedOperationException {
        return this.graphicalEffectRepository;
    }

    @Override
    public CharmedMobsRepository getServerCharmedMobsRepository() {
        return this.serverCharmedMobsRepository;
    }

    @Override
    public CharmedMobsRepository getClientCharmedMobsRepository() throws UnsupportedOperationException {
        return this.clientCharmedMobsRepository;
    }

    @Override
    public BlockDirectivesRepository getServerBlockDirectivesRepository() {
        return this.blockDirectivesRepository;
    }

    @Override
    public TemporaryBlockRepository getServerTemporaryBlockRepository() {
        return this.tempBlockRepository;
    }

    @Override
    public MobCommanderRepository getServerMobCommanderRepository() {
        return this.mobCommanderRepository;
    }

    @Override
    public TeamRepository getServerTeamRepository() {
        return this.teamRepository;
    }

    @Override
    public TargetRepository getServerTargetRepository() {
        return this.targetRepository;
    }

    @Override
    public void doDeferredRegistration(IEventBus bus) {
        RegisteredParticles.PARTICLE_REGISTRY.register(bus);
        RegisteredContainers.CONTAINER_REGISTRY.register(bus);
        RegisteredItems.ITEMS_REGISTRY.register(bus);
    }
}

