/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.screen;

import bassebombecraft.ModConstants;
import bassebombecraft.client.rendering.RenderingUtils;
import bassebombecraft.client.screen.DefaultAdviceGenerator;
import bassebombecraft.client.screen.ItemAdviceGenerator;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.inventory.container.CompositeMagicItemContainer;
import bassebombecraft.inventory.container.CompositeMagicItemItemStackHandler;
import bassebombecraft.inventory.container.CompositeMagicItemSequenceValidator;
import bassebombecraft.inventory.container.DefaultSequenceValidator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CompositeMagicItemScreen
extends ContainerScreen<CompositeMagicItemContainer> {
    static final int SEQUENCE_ICON_XDELTA = 18;
    static final int SEQUENCE_ICON_YPOS = 16;
    static final int SEQUENCE_ICON_XPOS = 16;
    static final int SEQUENCE_TEXTURE_SIZE = 32;
    static final int TEXT_COLOR = Color.BLACK.getRGB();
    static final float HEADER_XPOS = 8.0f;
    static final float HEADER_YPOS = 10.0f;
    static final float ADVICE_XPOS = 35.0f;
    static final float ADVICE_YPOS = 80.0f;
    static final ResourceLocation BACKGROUND_TEXTURE = RenderingUtils.createGuiTextureResourceLocation(CompositeMagicItemScreen.class);
    static final ResourceLocation SEQUENCE_TEXTURE = RenderingUtils.createGuiTextureResourceLocation("compositesequence");
    static final ResourceLocation DECORATION_TEXTURE = RenderingUtils.createGuiTextureResourceLocation("decoration");
    static final ResourceLocation DECORATION2_TEXTURE = RenderingUtils.createGuiTextureResourceLocation("decoration2");
    ItemAdviceGenerator adviceGenerator;
    CompositeMagicItemSequenceValidator validator;
    String guiHeader;

    public CompositeMagicItemScreen(CompositeMagicItemContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.adviceGenerator = new DefaultAdviceGenerator(container);
        this.validator = new DefaultSequenceValidator();
        this.guiHeader = new TranslationTextComponent("compositemagicscreen.header", ModConstants.NULL_I18N_ARGS).func_150254_d();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        CompositeMagicItemContainer compositeContainer = (CompositeMagicItemContainer)this.field_147002_h;
        CompositeMagicItemItemStackHandler compositeInventory = compositeContainer.getCompositeItemInventory();
        this.renderGuiHeader();
        this.renderAdvice();
        this.renderSequenceHighlight(compositeInventory);
        this.renderDecoration();
    }

    void renderGuiHeader() {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.font.func_211126_b(this.guiHeader, 8.0f, 10.0f, TEXT_COLOR);
        RenderSystem.popMatrix();
    }

    void renderAdvice() {
        String[] advice = this.adviceGenerator.generate();
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.6f, (float)0.6f, (float)1.0f);
        int index = 0;
        for (String message : advice) {
            float yPos = 80.0f + (float)(index * 10);
            this.font.func_211126_b(message, 35.0f, yPos, TEXT_COLOR);
            ++index;
        }
        RenderSystem.popMatrix();
    }

    void renderSequenceHighlight(CompositeMagicItemItemStackHandler compositeInventory) {
        int length = this.validator.resolveLegalSequenceLength(compositeInventory);
        float oscRgb = GeometryUtils.oscillateFloat(0.5f, 1.0f);
        RenderSystem.color4f((float)oscRgb, (float)oscRgb, (float)oscRgb, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(SEQUENCE_TEXTURE);
        for (int index = 0; index < length; ++index) {
            int inventoryIndex = compositeInventory.getCompositeInventoryIndex() + index;
            int xPos = 16 + inventoryIndex * 18;
            CompositeMagicItemScreen.blit((int)xPos, (int)16, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        }
    }

    void renderDecoration() {
        float oscRgb = GeometryUtils.oscillateFloat(0.5f, 1.0f);
        RenderSystem.color4f((float)1.0f, (float)oscRgb, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(DECORATION_TEXTURE);
        CompositeMagicItemScreen.blit((int)136, (int)55, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(DECORATION2_TEXTURE);
        CompositeMagicItemScreen.blit((int)10, (int)65, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderHelper.func_227783_c_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.blit(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

