/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.screen;

import bassebombecraft.client.screen.ItemAdviceGenerator;
import bassebombecraft.inventory.container.CompositeMagicItemContainer;
import bassebombecraft.inventory.container.CompositeMagicItemItemStackHandler;
import bassebombecraft.inventory.container.CompositeMagicItemSequenceValidator;
import bassebombecraft.inventory.container.DefaultSequenceValidator;

public class DefaultAdviceGenerator
implements ItemAdviceGenerator {
    static final String[] ADVICE_L0 = new String[]{"As item #1, add a Projectile Formation (PF)."};
    static final String[] ADVICE_L1 = new String[]{"As item #2, add a Projectile (P) or a", "Projectile Formation Modifier (PFM)."};
    static final String[] ADVICE_L2_P = new String[]{"As item #3, add a Projectile Path (PP)", "or a Projectile Modifier (PM)."};
    static final String[] ADVICE_L2_PFM = new String[]{"As item #3, add another PFM or a", "Projectile Path (PP) or a Projectile Modifier (PM)."};
    static final String[] ADVICE_L3_P = new String[]{"As item #4, add a Projectile Path (PP)", "or a Projectile Modifier (PM)."};
    static final String[] ADVICE_L3_PP = new String[]{"As item #4, add a Projectile Path (PP)", "or a Projectile Modifier (PM)."};
    static final String[] ADVICE_L3_PM = new String[]{"As item #4, add a Projectile Modifier (PM)."};
    static final String[] ADVICE_L4_PP = new String[]{"As item #5, add a Projectile Path (PP)", "or a Projectile Modifier (PM)."};
    static final String[] ADVICE_L4_PM = new String[]{"As item #5, add a Projectile Modifier (PM)."};
    static final String[] ADVICE_L5_PP = new String[]{"As item #6, add a Projectile Path (PP)", "or a Projectile Modifier (PM)."};
    static final String[] ADVICE_L5_PM = new String[]{"As item #6, add a Projectile Modifier (PM)."};
    static final String[] ADVICE_L6 = new String[]{"Impressive. A 6 item combo.."};
    static final String[] ADVICE_DEFAULT = new String[]{"The legal syntax is:", "Sequence = PF [PFM] P {PP} {PM}"};
    CompositeMagicItemContainer container;
    CompositeMagicItemSequenceValidator validator;

    public DefaultAdviceGenerator(CompositeMagicItemContainer container) {
        this.container = container;
        this.validator = new DefaultSequenceValidator();
    }

    @Override
    public String[] generate() {
        CompositeMagicItemItemStackHandler inventory = this.container.getCompositeItemInventory();
        int legalSequenceLength = this.validator.resolveLegalSequenceLength(inventory);
        switch (legalSequenceLength) {
            case 0: {
                return this.adviceOnLength0();
            }
            case 1: {
                return this.adviceOnLength1(inventory);
            }
            case 2: {
                return this.adviceOnLength2(inventory);
            }
            case 3: {
                return this.adviceOnLength3(inventory);
            }
            case 4: {
                return this.adviceOnLength4(inventory);
            }
            case 5: {
                return this.adviceOnLength5(inventory);
            }
            case 6: {
                return this.adviceOnLength6(inventory);
            }
        }
        return this.defaultAdvice();
    }

    String[] adviceOnLength0() {
        return ADVICE_L0;
    }

    String[] adviceOnLength1(CompositeMagicItemItemStackHandler inventory) {
        return ADVICE_L1;
    }

    String[] adviceOnLength2(CompositeMagicItemItemStackHandler inventory) {
        if (this.validator.isSecondItemProjectileFormationModifier(inventory)) {
            return ADVICE_L2_PFM;
        }
        return ADVICE_L2_P;
    }

    String[] adviceOnLength3(CompositeMagicItemItemStackHandler inventory) {
        if (this.validator.isSecondItemProjectileFormationModifier(inventory)) {
            return ADVICE_L3_P;
        }
        if (this.validator.isThirdItemProjectilePath(inventory)) {
            return ADVICE_L3_PP;
        }
        return ADVICE_L3_PM;
    }

    String[] adviceOnLength4(CompositeMagicItemItemStackHandler inventory) {
        if (this.validator.isFourthItemProjectilePath(inventory)) {
            return ADVICE_L4_PP;
        }
        return ADVICE_L4_PM;
    }

    String[] adviceOnLength5(CompositeMagicItemItemStackHandler inventory) {
        if (this.validator.isFifthItemProjectilePath(inventory)) {
            return ADVICE_L5_PP;
        }
        return ADVICE_L5_PM;
    }

    String[] adviceOnLength6(CompositeMagicItemItemStackHandler inventory) {
        return ADVICE_L6;
    }

    String[] defaultAdvice() {
        return ADVICE_DEFAULT;
    }
}

