/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.config.ParticlesConfig;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ProjectileEntityConfig {
    public ForgeConfigSpec.ConfigValue<String> tooltip;
    public ForgeConfigSpec.DoubleValue inaccuracy;
    public ForgeConfigSpec.DoubleValue force;
    public ForgeConfigSpec.DoubleValue damage;
    public ForgeConfigSpec.DoubleValue gravity;
    public ParticlesConfig particles;

    public ProjectileEntityConfig(ForgeConfigSpec.Builder builder, String name, double inaccuracy, double force, double damage, double gravity, Supplier<ParticlesConfig> splParticles) {
        builder.comment(name + " settings").push(name);
        this.inaccuracy = builder.comment("Projectile inaccuracy when fired.").defineInRange("inaccuracy", inaccuracy, 0.0, Double.MAX_VALUE);
        this.force = builder.comment("Projectile force when fired.").defineInRange("force", force, 0.0, 10.0);
        this.damage = builder.comment("Projectile damage when hitting a mob.").defineInRange("damage", damage, 0.0, Double.MAX_VALUE);
        this.gravity = builder.comment("Projectile gravity applied every tick.").defineInRange("gravity", gravity, 0.0, 1.0);
        this.particles = splParticles.get();
        builder.pop();
    }

    public static ProjectileEntityConfig getInstance(ForgeConfigSpec.Builder builder, String name, double inaccuracy, double force, double damage, double gravity, Supplier<ParticlesConfig> splParticles) {
        return new ProjectileEntityConfig(builder, name, inaccuracy, force, damage, gravity, splParticles);
    }
}

