/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.config.VersionInfo;
import bassebombecraft.config.http.HttpCallback;
import bassebombecraft.config.http.HttpRequestHandler;
import bassebombecraft.player.PlayerUtils;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.Logger;
import shadowed.org.apache.http.NameValuePair;
import shadowed.org.apache.http.client.HttpClient;
import shadowed.org.apache.http.client.methods.HttpPost;
import shadowed.org.apache.http.client.protocol.HttpClientContext;
import shadowed.org.apache.http.client.utils.URIBuilder;
import shadowed.org.apache.http.impl.client.FutureRequestExecutionService;
import shadowed.org.apache.http.impl.client.HttpClientBuilder;
import shadowed.org.apache.http.message.BasicNameValuePair;

public class VersionUtils {
    static HttpClient httpClient = HttpClientBuilder.create().build();
    static final HttpClientContext HTTP_CONTEXT = HttpClientContext.create();
    static ExecutorService executorService = Executors.newFixedThreadPool(2);
    static FutureRequestExecutionService executionService = new FutureRequestExecutionService(httpClient, executorService);
    static HttpCallback callBack = new HttpCallback();
    static HttpRequestHandler requestHandler = new HttpRequestHandler();

    public static void startSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        String action = "Start session";
        List<NameValuePair> postParameters = VersionUtils.createStartAppSessionParameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
        action = "System info";
        postParameters = VersionUtils.createSystemInfoParameters(uid, category, action);
        uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        uri = uriBuilder.build();
        request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void endSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        String action = "End session";
        List<NameValuePair> postParameters = VersionUtils.createEndAppSessionPerameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void postItemUsageEvent(String uid, String itemName) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        String action = itemName;
        List<NameValuePair> postParameters = VersionUtils.createPostItemUsageEventParameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void startServerSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        String action = "Start server session";
        List<NameValuePair> postParameters = VersionUtils.createStartAppSessionParameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
        action = "System info (Server)";
        postParameters = VersionUtils.createSystemInfoParameters(uid, category, action);
        uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        uri = uriBuilder.build();
        request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void endServerSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        String action = "End server session";
        List<NameValuePair> postParameters = VersionUtils.createEndAppSessionPerameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void postException(String uid, Throwable e) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String description = sw.toString() + System.getProperty("line.separator") + VersionUtils.createUserInfo(uid);
        List<NameValuePair> postParameters = VersionUtils.createExceptionParameters(uid, category, description);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void postError(String uid, String msg) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        String description = msg + System.getProperty("line.separator") + VersionUtils.createUserInfo(uid);
        List<NameValuePair> postParameters = VersionUtils.createExceptionParameters(uid, category, description);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    public static void postAiObservation(String uid, String type, String observation) throws Exception {
        String category = "BasseBombeCraft-1.15.2-1.50";
        List<NameValuePair> postParameters = VersionUtils.createPostAiEventParameters(uid, category, observation);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        executionService.execute(request, HTTP_CONTEXT, requestHandler, callBack);
    }

    static List<NameValuePair> createStartAppSessionParameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "event"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("ec", category));
        parameters.add(new BasicNameValuePair("ea", action));
        parameters.add(new BasicNameValuePair("el", uid));
        parameters.add(new BasicNameValuePair("sc", "start"));
        return parameters;
    }

    static List<NameValuePair> createSystemInfoParameters(String uid, String category, String action) {
        String userInfo = VersionUtils.createUserInfo(uid);
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "event"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("ec", category));
        parameters.add(new BasicNameValuePair("ea", action));
        parameters.add(new BasicNameValuePair("el", userInfo));
        return parameters;
    }

    static List<NameValuePair> createEndAppSessionPerameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "event"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("ec", category));
        parameters.add(new BasicNameValuePair("ea", action));
        parameters.add(new BasicNameValuePair("el", uid));
        parameters.add(new BasicNameValuePair("sc", "end"));
        return parameters;
    }

    static List<NameValuePair> createPostItemUsageEventParameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "event"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("ec", category));
        parameters.add(new BasicNameValuePair("ea", action));
        parameters.add(new BasicNameValuePair("el", uid));
        return parameters;
    }

    static List<NameValuePair> createExceptionEventParameters(String uid, String category, String description) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "event"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("ec", category));
        parameters.add(new BasicNameValuePair("ea", "Exception"));
        parameters.add(new BasicNameValuePair("el", description));
        return parameters;
    }

    static List<NameValuePair> createExceptionParameters(String uid, String category, String description) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "exception"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("exd", description));
        parameters.add(new BasicNameValuePair("exf", "0"));
        return parameters;
    }

    static List<NameValuePair> createPostAiEventParameters(String uid, String category, String observation) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new BasicNameValuePair("v", "1"));
        parameters.add(new BasicNameValuePair("t", "event"));
        parameters.add(new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add(new BasicNameValuePair("ds", "app"));
        parameters.add(new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add(new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add(new BasicNameValuePair("av", "1.15.2-1.50"));
        parameters.add(new BasicNameValuePair("cid", uid));
        parameters.add(new BasicNameValuePair("uid", uid));
        parameters.add(new BasicNameValuePair("ec", category));
        parameters.add(new BasicNameValuePair("ea", "AI Observe"));
        parameters.add(new BasicNameValuePair("el", observation));
        return parameters;
    }

    static String createUserInfo(String uid) {
        Optional<MinecraftServer> optServer = BassebombeCraft.getBassebombeCraft().getServer();
        String mcVersion = optServer.map(s -> s.func_71249_w()).orElse("N/A");
        String forgeVersion = ForgeVersion.getVersion();
        String mcpVersion = MCPVersion.getMCPVersion();
        String userInfo = uid + ";" + System.getProperty("os.name") + "," + System.getProperty("os.version") + "," + System.getProperty("os.arch") + ";" + System.getProperty("java.version") + ";" + VersionUtils.getJvmArgs() + mcVersion + ";" + forgeVersion + ";" + mcpVersion + ";";
        return userInfo;
    }

    static String getJvmArgs() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> jvmArgs = runtimeMXBean.getInputArguments();
            StringBuilder args = new StringBuilder();
            args.append("JVM args:");
            for (String arg : jvmArgs) {
                args.append(arg).append(";");
            }
            return args.toString();
        }
        catch (Exception e) {
            return "JVM args: Not accessible";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateVersion(PlayerEntity player) {
        Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
        Gson gson = new Gson();
        InputStream is = null;
        try {
            URL url = new URL("https://raw.githubusercontent.com/athrane/bassebombecraft/master/version.json");
            is = url.openStream();
            String json = new String(ByteStreams.toByteArray((InputStream)is), "UTF-8");
            is.close();
            VersionInfo info = (VersionInfo)gson.fromJson(json, VersionInfo.class);
            String version = info.minecraftVersion + "-" + info.modVersion;
            logger.info("Starting version check at: https://raw.githubusercontent.com/athrane/bassebombecraft/master/version.json");
            if (!"1.15.2-1.50".equalsIgnoreCase(version)) {
                String message = "A newer version of BasseBombeCraft is available.";
                logger.info(message);
                if (((Boolean)ModConfiguration.enableWelcomeMessage.get()).booleanValue()) {
                    PlayerUtils.sendChatMessageToPlayer(player, message);
                }
                message = "The newest version is: " + version;
                logger.info(message);
                if (((Boolean)ModConfiguration.enableWelcomeMessage.get()).booleanValue()) {
                    PlayerUtils.sendChatMessageToPlayer(player, message);
                }
                return;
            }
            String message = "The most current version of BasseBombeCraft is used: " + version;
            logger.info(message);
            if (((Boolean)ModConfiguration.enableWelcomeMessage.get()).booleanValue()) {
                PlayerUtils.sendChatMessageToPlayer(player, message);
            }
        }
        catch (Exception e) {
            logger.info("Failed to validate version due to exception:" + e.getMessage());
            BassebombeCraft.getBassebombeCraft().reportException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.info("Failed to close connection for version validation due to exception:" + e.getMessage());
                BassebombeCraft.getBassebombeCraft().reportException(e);
            }
        }
    }
}

