/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai.goal;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.frequency.FrequencyRepository;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;

public class FollowEntityGoal
extends Goal {
    final MobEntity entity;
    LivingEntity leaderEntity;
    double followSpeed;
    float minDistance;
    float maxDistance;
    float minDistanceSqr;

    public FollowEntityGoal(MobEntity entity, LivingEntity leader, double followSpeed, float minDist, float maxDist) {
        this.entity = entity;
        this.leaderEntity = leader;
        this.followSpeed = followSpeed;
        this.minDistance = minDist;
        this.maxDistance = maxDist;
        this.minDistanceSqr = this.minDistance * this.minDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.leaderEntity == null) {
            return false;
        }
        if (!this.leaderEntity.func_70089_S()) {
            this.leaderEntity = null;
            return false;
        }
        boolean isMinDistReached = EntityUtils.isMinimumDistanceReached((Entity)this.entity, (Entity)this.leaderEntity, this.minDistanceSqr);
        return !isMinDistReached;
    }

    public void func_75249_e() {
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75246_d() {
        try {
            LookController lookController = this.entity.func_70671_ap();
            lookController.func_75651_a((Entity)this.leaderEntity, 10.0f, (float)this.entity.func_70646_bf());
            FrequencyRepository repository = BassebombeCraft.getProxy().getServerFrequencyRepository();
            if (!repository.isActive(10)) {
                return;
            }
            PathNavigator navigator = this.entity.func_70661_as();
            navigator.func_75497_a((Entity)this.leaderEntity, this.followSpeed);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void func_75251_c() {
        PathNavigator navigator = this.entity.func_70661_as();
        navigator.func_75499_g();
    }
}

