/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.projectile;

import bassebombecraft.entity.projectile.GenericCompositeProjectileEntity;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;

public class ProjectileUtils {
    public static boolean isBlockHit(RayTraceResult result) {
        if (result == null) {
            return false;
        }
        return result.func_216346_c() == RayTraceResult.Type.BLOCK;
    }

    public static boolean isEntityHit(RayTraceResult result) {
        if (result == null) {
            return false;
        }
        return result.func_216346_c() == RayTraceResult.Type.ENTITY;
    }

    public static boolean isNothingHit(RayTraceResult result) {
        if (result == null) {
            return false;
        }
        return result.func_216346_c() == RayTraceResult.Type.MISS;
    }

    public static boolean isTypeEntityRayTraceResult(RayTraceResult result) {
        if (result == null) {
            return false;
        }
        return result instanceof EntityRayTraceResult;
    }

    public static boolean isTypeBlockRayTraceResult(RayTraceResult result) {
        if (result == null) {
            return false;
        }
        return result instanceof BlockRayTraceResult;
    }

    public static Optional<LivingEntity> resolveInvoker(ProjectileImpactEvent event) {
        if (event instanceof ProjectileImpactEvent.Arrow) {
            ProjectileImpactEvent.Arrow arrowEvent = (ProjectileImpactEvent.Arrow)event;
            AbstractArrowEntity arrowProjectile = arrowEvent.getArrow();
            Entity invoker = arrowProjectile.func_212360_k();
            if (invoker instanceof LivingEntity) {
                return Optional.of((LivingEntity)invoker);
            }
            return Optional.empty();
        }
        if (event instanceof ProjectileImpactEvent.Fireball) {
            ProjectileImpactEvent.Fireball fireballEvent = (ProjectileImpactEvent.Fireball)event;
            DamagingProjectileEntity fireballProjectile = fireballEvent.getFireball();
            return Optional.of(fireballProjectile.field_70235_a);
        }
        if (event instanceof ProjectileImpactEvent.Throwable) {
            ProjectileImpactEvent.Throwable throwableEvent = (ProjectileImpactEvent.Throwable)event;
            ThrowableEntity throwableProjectile = throwableEvent.getThrowable();
            return Optional.of(throwableProjectile.func_85052_h());
        }
        Entity projectile = event.getEntity();
        if (projectile instanceof GenericCompositeProjectileEntity) {
            GenericCompositeProjectileEntity genericProjectile = (GenericCompositeProjectileEntity)projectile;
            return Optional.of(genericProjectile.getThrower());
        }
        return Optional.empty();
    }
}

