/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.charm.ServerCharmedMob;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;

public class ServerCharmedMobsRepository
implements CharmedMobsRepository {
    public static final String NAME = ServerCharmedMobsRepository.class.getSimpleName();
    Consumer<String> cRemovalCallback = id -> this.remove((String)id);
    Map<String, CharmedMob> charmedMobs = new ConcurrentHashMap<String, CharmedMob>();

    @Override
    public void add(MobEntity entity, LivingEntity commander) {
        try {
            TeamRepository repository = BassebombeCraft.getProxy().getServerTeamRepository();
            if (repository.isMember(commander, (LivingEntity)entity)) {
                return;
            }
            Integer duration = (Integer)ModConfiguration.charmDuration.get();
            ServerCharmedMob charmedMob = ServerCharmedMob.getInstance(entity, duration);
            if (this.contains(charmedMob.getId())) {
                return;
            }
            AiUtils.clearAllAiGoals(entity);
            AiUtils.buildCharmedMobAi(entity, commander);
            String id = Integer.toString(entity.func_145782_y());
            this.charmedMobs.put(id, charmedMob);
            DurationRepository durationRepository = BassebombeCraft.getProxy().getServerDurationRepository();
            durationRepository.add(id, duration, this.cRemovalCallback);
            BassebombeCraft.getProxy().getNetworkChannel().sendAddCharmPacket(entity);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @Override
    public void remove(String id) {
        if (!this.contains(id)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(id);
        AiUtils.clearAllAiGoals(charmedMob.getEntity());
        AiUtils.assignAiGoals(charmedMob.getEntity(), charmedMob.getGoals());
        AiUtils.assignAiTargetGoals(charmedMob.getEntity(), charmedMob.getTargetGoals());
        this.charmedMobs.remove(id);
    }

    @Override
    public void remove(MobEntity entity) {
        int id = entity.func_145782_y();
        String idAsString = Integer.toString(id);
        this.remove(idAsString);
    }

    @Override
    public boolean contains(String id) {
        return this.charmedMobs.containsKey(id);
    }

    @Override
    public boolean contains(MobEntity entity) {
        int id = entity.func_145782_y();
        String idAsString = Integer.toString(id);
        return this.charmedMobs.containsKey(idAsString);
    }

    @Override
    public Stream<CharmedMob> get() {
        return this.charmedMobs.values().stream();
    }

    @Override
    public int size() {
        return this.charmedMobs.size();
    }

    public static CharmedMobsRepository getInstance() {
        return new ServerCharmedMobsRepository();
    }
}

