/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.team;

import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.player.PlayerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class DefaultTeamRepository
implements TeamRepository {
    static final Set<LivingEntity> nullMembersSet = new HashSet<LivingEntity>();
    Map<LivingEntity, Team> teams = new ConcurrentHashMap<LivingEntity, Team>();
    Map<LivingEntity, Team> teamMembership = new ConcurrentHashMap<LivingEntity, Team>();

    @Override
    public void createTeam(PlayerEntity commander) {
        if (commander == null) {
            return;
        }
        if (this.isCommander(commander)) {
            return;
        }
        Team team = new Team(commander);
        this.teams.put((LivingEntity)commander, team);
    }

    @Override
    public void deleteTeam(PlayerEntity commander) {
        if (commander == null) {
            return;
        }
        if (!this.isCommander(commander)) {
            return;
        }
        Team team = this.teams.get(commander);
        Set<LivingEntity> members = team.members;
        members.forEach(t -> this.teamMembership.remove(t));
        this.teams.remove(commander);
    }

    @Override
    public int size(PlayerEntity commander) {
        if (commander == null) {
            return 0;
        }
        if (!this.isCommander(commander)) {
            return 0;
        }
        Team team = this.teams.get(commander);
        return team.members.size();
    }

    void addToCommandersTeam(PlayerEntity commander, LivingEntity entity) {
        if (!this.isCommander(commander)) {
            this.createTeam(commander);
        }
        Team team = this.teams.get(commander);
        this.teamMembership.put(entity, team);
        team.members.add(entity);
    }

    @Override
    public void add(LivingEntity creator, LivingEntity entity) {
        if (creator == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (PlayerUtils.isTypePlayerEntity((Entity)creator)) {
            PlayerEntity commander = (PlayerEntity)creator;
            this.addToCommandersTeam(commander, entity);
            return;
        }
        if (!this.teamMembership.containsKey(creator)) {
            return;
        }
        Team team = this.teamMembership.get(creator);
        PlayerEntity commander = team.commander;
        this.addToCommandersTeam(commander, entity);
    }

    @Override
    public boolean isCommander(PlayerEntity commander) {
        if (commander == null) {
            return false;
        }
        return this.teams.containsKey(commander);
    }

    @Override
    public void remove(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        if (!this.teamMembership.containsKey(entity)) {
            return;
        }
        Team team = this.teamMembership.get(entity);
        team.members.remove(entity);
        this.teamMembership.remove(entity);
    }

    @Override
    public boolean isMember(LivingEntity commander, LivingEntity entity) {
        if (commander == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        Team team = this.teams.get(commander);
        if (team == null) {
            return false;
        }
        return team.members.contains(entity);
    }

    @Override
    public boolean isTeamMembers(LivingEntity entity, LivingEntity entity2) {
        if (entity == null) {
            return false;
        }
        if (entity2 == null) {
            return false;
        }
        Team team = this.teamMembership.get(entity);
        Team team2 = this.teamMembership.get(entity2);
        if (team == null) {
            return false;
        }
        if (team2 == null) {
            return false;
        }
        return team.equals(team2);
    }

    @Override
    public Collection<LivingEntity> get(PlayerEntity commander) {
        if (commander == null) {
            return nullMembersSet;
        }
        if (!this.isCommander(commander)) {
            return nullMembersSet;
        }
        Team team = this.teams.get(commander);
        return team.members;
    }

    public static TeamRepository getInstance() {
        return new DefaultTeamRepository();
    }

    class Team {
        PlayerEntity commander;
        Set<LivingEntity> members = Collections.synchronizedSet(new HashSet());

        public Team(PlayerEntity commander) {
            this.commander = commander;
        }

        public boolean equals(Object obj) {
            Team team = (Team)obj;
            return this.commander.equals((Object)team.commander);
        }

        public String toString() {
            return "Team: " + this.commander.func_146103_bH().getName();
        }
    }
}

