/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.team;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.world.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TeamEventHandler {
    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            TeamRepository repository = BassebombeCraft.getProxy().getServerTeamRepository();
            if (EntityUtils.isTypeLivingEntity((Entity)event.getEntityLiving())) {
                LivingEntity entity = event.getEntityLiving();
                repository.remove(entity);
                return;
            }
            if (PlayerUtils.isTypePlayerEntity((Entity)event.getEntityLiving())) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (!repository.isCommander(player)) {
                    return;
                }
                repository.deleteTeam(player);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            TeamRepository repository = BassebombeCraft.getProxy().getServerTeamRepository();
            repository.createTeam(event.getPlayer());
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            TeamRepository repository = BassebombeCraft.getProxy().getServerTeamRepository();
            repository.deleteTeam(event.getPlayer());
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }
}

