/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.job;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.event.job.Job;
import bassebombecraft.event.job.JobRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class DefaultJobReposiory
implements JobRepository {
    Consumer<String> cRemovalCallback = id -> this.remove((String)id);
    Consumer<String> cUpdateCallback = id -> this.update((String)id);
    Map<String, Job> jobs = new ConcurrentHashMap<String, Job>();

    @Override
    public void add(String id, int duration, Job job) {
        try {
            if (this.contains(id)) {
                return;
            }
            DurationRepository repository = BassebombeCraft.getProxy().getServerDurationRepository();
            repository.add(id, duration, this.cUpdateCallback, this.cRemovalCallback);
            this.jobs.put(id, job);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @Override
    public void remove(String id) {
        if (!this.contains(id)) {
            return;
        }
        this.jobs.remove(id);
    }

    public void update(String id) {
        if (!this.contains(id)) {
            return;
        }
        Job job = this.jobs.get(id);
        job.update();
    }

    @Override
    public boolean contains(String id) {
        return this.jobs.containsKey(id);
    }

    public static JobRepository getInstance() {
        return new DefaultJobReposiory();
    }
}

