/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import java.util.Random;
import java.util.UUID;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;

public class DefaultParticleRendering
implements ParticleRendering {
    String id;
    BlockPos position;
    ParticleRenderingInfo info;

    DefaultParticleRendering(BlockPos pos, ParticleRenderingInfo info) {
        this.id = UUID.randomUUID().toString();
        this.position = pos;
        this.info = info;
    }

    DefaultParticleRendering(String id, BlockPos pos, ParticleRenderingInfo info) {
        this.id = id;
        this.position = pos;
        this.info = info;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public BasicParticleType getParticleType() {
        return this.info.getParticleType();
    }

    @Override
    public int getNumber() {
        return this.info.getNumber();
    }

    @Override
    public float getRedColorComponent(Random random) {
        float rgbRed = this.info.getRedColorComponent();
        return random.nextFloat() * 0.25f + rgbRed * 0.75f - 0.12f;
    }

    @Override
    public float getGreenColorComponent(Random random) {
        float rgbGreen = this.info.getGreenColorComponent();
        return random.nextFloat() * 0.25f + rgbGreen * 0.75f - 0.12f;
    }

    @Override
    public float getBlueColorComponent(Random random) {
        float rgbBlue = this.info.getBlueColorComponent();
        return random.nextFloat() * 0.25f + rgbBlue * 0.75f - 0.12f;
    }

    @Override
    public ParticleRenderingInfo getInfo() {
        return this.info;
    }

    public static ParticleRendering getInstance(BlockPos pos, ParticleRenderingInfo info) {
        return new DefaultParticleRendering(pos, info);
    }

    public static ParticleRendering getInstance(String id, BlockPos pos, ParticleRenderingInfo info) {
        return new DefaultParticleRendering(id, pos, info);
    }
}

