/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.geom;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.Structure;
import java.awt.geom.AffineTransform;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GeometryUtils {
    public static final int DEGREES_0 = 0;
    public static final int DEGREES_90 = 90;
    public static final int DEGREES_180 = 180;
    public static final int DEGREES_270 = 270;
    public static final int ITERATIONS_TO_QUERY_FOR_GROUND_BLOCK = 256;

    public static void captureBlockDirectives(Stream<BlockPos> blocks, World world, Collection<BlockDirective> destCollection) {
        blocks.map(p -> BlockDirective.getInstance(p, BlockUtils.getBlockFromPosition(p, world), BlockUtils.getBlockStateFromPosition(p, world), false, world)).forEach(destCollection::add);
    }

    public static List<BlockDirective> calculateBlockDirectives(Stream<BlockPos> blocks, Block block, BlockState blockState, boolean harvest, PlayerEntity player) {
        return blocks.map(p -> BlockDirective.getInstance(p, block, blockState, harvest, player)).collect(Collectors.toList());
    }

    public static List<BlockDirective> calculateBlockDirectives(Stream<BlockPos> blocks, Block block, BlockState blockState, boolean harvest, World world) {
        return blocks.map(p -> BlockDirective.getInstance(p, block, blockState, harvest, world)).collect(Collectors.toList());
    }

    public static List<BlockDirective> rotateCoordinatesAroundYAxis(BlockPos offset, double angle, List<BlockDirective> source) {
        ArrayList<BlockDirective> result = new ArrayList<BlockDirective>();
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(angle), offset.func_177958_n(), offset.func_177952_p());
        for (BlockDirective sourceDirective : source) {
            double[] rotationPoint = new double[]{sourceDirective.getBlockPosition().func_177958_n(), sourceDirective.getBlockPosition().func_177952_p()};
            transform.transform(rotationPoint, 0, rotationPoint, 0, 1);
            BlockPos rotatedPosition = new BlockPos((int)rotationPoint[0], sourceDirective.getBlockPosition().func_177956_o(), (int)rotationPoint[1]);
            BlockDirective rotatedDirective = BlockDirective.getInstance(sourceDirective, rotatedPosition);
            BlockDirective.getInstance(rotatedPosition, sourceDirective.getBlock(), sourceDirective.harvestBlock(), sourceDirective.getWorld());
            BlockState sourceState = sourceDirective.getState();
            BlockState rotatedState = BlockUtils.rotateBlockStateWithFacingProperty(sourceState, angle);
            rotatedDirective.setState(rotatedState);
            result.add(rotatedDirective);
        }
        return result;
    }

    public static List<BlockDirective> rotateCoordinatesAroundYAxisAtOrigin(double angle, List<BlockDirective> source) {
        return GeometryUtils.rotateCoordinatesAroundYAxis(ModConstants.ORIGIN_BLOCK_POS, angle, source);
    }

    public static Vec3d rotateUnitVectorAroundYAxisAtOrigin(double angle, Vec3d vector) {
        double originX = 0.0;
        double originZ = 0.0;
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(angle), originX, originZ);
        double[] rotationPoint = new double[]{vector.field_72450_a, vector.field_72449_c};
        transform.transform(rotationPoint, 0, rotationPoint, 0, 1);
        return new Vec3d(rotationPoint[0], vector.field_72448_b, rotationPoint[1]);
    }

    private static List<BlockDirective> calculateBlockDirectivesFromChildStructure(BlockPos offset, PlayerEntity player, Structure structure, boolean harvest) {
        if (structure.isComposite()) {
            return new ArrayList<BlockDirective>();
        }
        BlockPos from = offset.func_177982_a(structure.getOffsetX(), structure.getOffsetY(), structure.getOffsetZ());
        int xTo = structure.getSizeX() - 1;
        int yTo = structure.getSizeY() - 1;
        int zTo = structure.getSizeZ() - 1;
        BlockPos to = from.func_177982_a(xTo, yTo, zTo);
        Stream blocks = BlockPos.func_218281_b((BlockPos)from, (BlockPos)to);
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives((Stream<BlockPos>)blocks, structure.getBlock(), structure.getBlockState(), harvest, player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        int rotationDegrees = GeometryUtils.calculateDegreesFromPlayerDirection(playerDirection);
        List<BlockDirective> rotatedDirectives = GeometryUtils.rotateCoordinatesAroundYAxis(offset, rotationDegrees, directives);
        return rotatedDirectives;
    }

    private static List<BlockDirective> calculateBlockDirectivesFromChildStructure(BlockPos offset, PlayerDirection playerDirection, Structure structure, boolean harvest, World world) {
        if (structure.isComposite()) {
            return new ArrayList<BlockDirective>();
        }
        BlockPos from = offset.func_177982_a(structure.getOffsetX(), structure.getOffsetY(), structure.getOffsetZ());
        int xTo = structure.getSizeX() - 1;
        int yTo = structure.getSizeY() - 1;
        int zTo = structure.getSizeZ() - 1;
        BlockPos to = from.func_177982_a(xTo, yTo, zTo);
        Stream blocks = BlockPos.func_218281_b((BlockPos)from, (BlockPos)to);
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives((Stream<BlockPos>)blocks, structure.getBlock(), structure.getBlockState(), harvest, world);
        int rotationDegrees = GeometryUtils.calculateDegreesFromPlayerDirection(playerDirection);
        List<BlockDirective> rotatedDirectives = GeometryUtils.rotateCoordinatesAroundYAxis(offset, rotationDegrees, directives);
        return rotatedDirectives;
    }

    public static List<BlockDirective> calculateBlockDirectives(BlockPos offset, PlayerEntity player, Structure structure, boolean harvest) {
        if (!structure.isComposite()) {
            return GeometryUtils.calculateBlockDirectivesFromChildStructure(offset, player, structure, harvest);
        }
        ArrayList<BlockDirective> compositeResult = new ArrayList<BlockDirective>();
        for (Structure child : structure.getChildren()) {
            compositeResult.addAll(GeometryUtils.calculateBlockDirectives(offset, player, child, harvest));
        }
        return compositeResult;
    }

    public static List<BlockDirective> calculateBlockDirectives(BlockPos offset, PlayerDirection playerDirection, Structure structure, boolean harvest, World world) {
        if (!structure.isComposite()) {
            return GeometryUtils.calculateBlockDirectivesFromChildStructure(offset, playerDirection, structure, harvest, world);
        }
        ArrayList<BlockDirective> compositeResult = new ArrayList<BlockDirective>();
        for (Structure child : structure.getChildren()) {
            compositeResult.addAll(GeometryUtils.calculateBlockDirectives(offset, playerDirection, child, harvest, world));
        }
        return compositeResult;
    }

    public static int calculateDegreesFromPlayerDirection(PlayerDirection playerDirection) {
        switch (playerDirection) {
            case South: {
                return 0;
            }
            case West: {
                return 90;
            }
            case North: {
                return 180;
            }
            case East: {
                return 270;
            }
        }
        return 0;
    }

    public static PlayerDirection convertToPlayerDirection(Direction direction) {
        switch (direction) {
            case EAST: {
                return PlayerDirection.East;
            }
            case WEST: {
                return PlayerDirection.West;
            }
            case NORTH: {
                return PlayerDirection.North;
            }
            case SOUTH: {
                return PlayerDirection.South;
            }
        }
        return PlayerDirection.East;
    }

    public static int calculateYOffsetFromBlock(PlayerEntity player, BlockPos blockPosition) {
        int yFeetPosition = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        int offset = blockPosition.func_177956_o() - yFeetPosition;
        return offset;
    }

    public static List<BlockDirective> captureRectangle(BlockPos offset, BlockPos size, World world) {
        ArrayList<BlockDirective> result = new ArrayList<BlockDirective>();
        int yCounter = 0;
        while (true) {
            int layerZDelta;
            int layerYDelta;
            int layerXDelta;
            BlockPos to;
            int currentY = yCounter + offset.func_177956_o();
            BlockPos from = new BlockPos(offset.func_177958_n(), currentY, offset.func_177952_p());
            Stream blocks = BlockPos.func_218281_b((BlockPos)from, (BlockPos)(to = from.func_177982_a(layerXDelta = size.func_177958_n() - 1, layerYDelta = 0, layerZDelta = size.func_177952_p() - 1)));
            if (!BlockUtils.containsNonAirBlocks(blocks, world)) {
                return result;
            }
            blocks = BlockPos.func_218281_b((BlockPos)from, (BlockPos)to);
            GeometryUtils.captureBlockDirectives(blocks, world, result);
            ++yCounter;
        }
    }

    public static List<BlockDirective> translate(BlockPos translationVector, List<BlockDirective> directives) {
        ArrayList<BlockDirective> translated = new ArrayList<BlockDirective>();
        for (BlockDirective directive : directives) {
            BlockDirective translatedDirective = BlockDirective.getInstance(directive);
            translatedDirective.translate(translationVector);
            translated.add(translatedDirective);
        }
        return translated;
    }

    public static List<BlockPos> calculateSpiral(int maxX, int maxY) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        int x = 0;
        int y = 0;
        int dx = 0;
        int dy = -1;
        int t = Math.max(maxX, maxY);
        int maxI = t * t;
        for (int i = 0; i < maxI; ++i) {
            if (-maxX / 2 <= x && x <= maxX / 2 && -maxY / 2 <= y && y <= maxY / 2) {
                BlockPos pos = new BlockPos(x, 0, y);
                coords.add(pos);
            }
            if (x == y || x < 0 && x == -y || x > 0 && x == 1 - y) {
                t = dx;
                dx = -dy;
                dy = t;
            }
            x += dx;
            y += dy;
        }
        return coords;
    }

    public static BlockPos locateGroundBlockPos(BlockPos target, int iterations, World world) {
        if (iterations == 0) {
            return target;
        }
        if (iterations < 0) {
            return target;
        }
        int newIterations = iterations - 1;
        if (!GeometryUtils.isUsefullAirTypeBlock(target.func_177984_a(), world)) {
            return GeometryUtils.locateGroundBlockPos(target.func_177984_a(), newIterations, world);
        }
        if (!GeometryUtils.isUsefulGroundBlock(target, world)) {
            return GeometryUtils.locateGroundBlockPos(target.func_177977_b(), newIterations, world);
        }
        return target;
    }

    static boolean isUsefulGroundBlock(BlockPos target, World world) {
        Block block = BlockUtils.getBlockFromPosition(target, world);
        BlockState defaultState = block.func_176223_P();
        Material material = defaultState.func_185904_a();
        return material.func_76220_a();
    }

    static boolean isUsefullAirTypeBlock(BlockPos target, World world) {
        Block block = BlockUtils.getBlockFromPosition(target, world);
        BlockState defaultState = block.func_176223_P();
        Material material = defaultState.func_185904_a();
        return !material.func_76220_a();
    }

    public static BlockDirective createFlowerDirective(BlockPos position, World world) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        Block blockType = GeometryUtils.selectFlower(random);
        return BlockDirective.getInstance(position, blockType, false, world);
    }

    static Block selectFlower(Random random) {
        int flowerType = random.nextInt(12);
        switch (flowerType) {
            case 0: {
                return Blocks.field_196609_bf;
            }
            case 1: {
                return Blocks.field_196610_bg;
            }
            case 2: {
                return Blocks.field_196607_be;
            }
            case 3: {
                return Blocks.field_222387_by;
            }
            case 4: {
                return Blocks.field_196605_bc;
            }
            case 5: {
                return Blocks.field_222383_bA;
            }
            case 6: {
                return Blocks.field_196613_bi;
            }
            case 7: {
                return Blocks.field_196616_bl;
            }
            case 8: {
                return Blocks.field_196615_bk;
            }
            case 9: {
                return Blocks.field_196606_bd;
            }
            case 10: {
                return Blocks.field_196612_bh;
            }
            case 11: {
                return Blocks.field_196614_bj;
            }
        }
        return Blocks.field_196612_bh;
    }

    public static double calculateDistanceSq(BlockPos pos1, BlockPos pos2) {
        double d0 = (double)pos1.func_177958_n() - (double)pos2.func_177958_n();
        double d1 = (double)pos1.func_177956_o() - (double)pos2.func_177956_o();
        double d2 = (double)pos1.func_177952_p() - (double)pos2.func_177952_p();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public static double calculateDistance(BlockPos pos1, BlockPos pos2) {
        return MathHelper.func_76133_a((double)GeometryUtils.calculateDistanceSq(pos1, pos2));
    }

    public static double oscillate(float min, float max) {
        long time = Instant.now().toEpochMilli() / 10L;
        return (double)min + (Math.sin(Math.toRadians(time)) + 1.0) / 2.0 * (double)(max - min);
    }

    public static float oscillateFloat(float min, float max) {
        return (float)GeometryUtils.oscillate(min, max);
    }

    public static double oscillateWithDeltaTime(long timeDelta, float min, float max) {
        long time = Instant.now().toEpochMilli() / 10L + timeDelta;
        return (double)min + (Math.sin(Math.toRadians(time)) + 1.0) / 2.0 * (double)(max - min);
    }

    public static double oscillateWithFixedTime(long time, float min, float max) {
        return (double)min + (Math.sin(Math.toRadians(time)) + 1.0) / 2.0 * (double)(max - min);
    }
}

