/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.inventory.container;

import bassebombecraft.inventory.container.CompositeMagicItemItemStackHandler;
import bassebombecraft.inventory.container.CompositeMagicItemSequenceValidator;
import net.minecraft.item.ItemStack;

public class DefaultSequenceValidator
implements CompositeMagicItemSequenceValidator {
    @Override
    public int resolveLegalSequenceLength(CompositeMagicItemItemStackHandler inventory) {
        int index = inventory.getCompositeInventoryIndex();
        if (index == -1) {
            return 0;
        }
        if (!this.isPos1LegalSequence(inventory)) {
            return 0;
        }
        if (!this.isPos2LegalSequence(inventory)) {
            return 1;
        }
        if (!this.isPos3LegalSequence(inventory)) {
            return 2;
        }
        if (!this.isPos4LegalSequence(inventory)) {
            return 3;
        }
        if (!this.isPos5LegalSequence(inventory)) {
            return 4;
        }
        if (!this.isPos6LegalSequence(inventory)) {
            return 5;
        }
        return 6;
    }

    @Override
    public boolean isFirstItemProjectileFormation(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 0, "ProjectileFormationItem");
    }

    @Override
    public boolean isSecondItemProjectileFormationModifier(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 1, "ProjectileFormationModifierItem");
    }

    @Override
    public boolean isSecondItemProjectile(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 1, "ProjectileItem");
    }

    @Override
    public boolean isThirdItemProjectile(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 2, "ProjectileItem");
    }

    @Override
    public boolean isThirdItemProjectileFormationModifier(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 2, "ProjectileFormationModifierItem");
    }

    @Override
    public boolean isThirdItemProjectilePath(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 2, "ProjectilePathItem");
    }

    @Override
    public boolean isThirdItemProjectileModifier(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 2, "ProjectileModifierItem");
    }

    @Override
    public boolean isFourthItemProjectilePath(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 3, "ProjectilePathItem");
    }

    @Override
    public boolean isFourthItemProjectileModifier(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 3, "ProjectileModifierItem");
    }

    @Override
    public boolean isFifthItemProjectilePath(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 4, "ProjectilePathItem");
    }

    @Override
    public boolean isFifthItemProjectileModifier(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 4, "ProjectileModifierItem");
    }

    @Override
    public boolean isSixthItemProjectilePath(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 5, "ProjectilePathItem");
    }

    @Override
    public boolean isSixthItemProjectileModifier(CompositeMagicItemItemStackHandler inventory) {
        return this.isItemAt(inventory, 5, "ProjectileModifierItem");
    }

    boolean isItemAt(CompositeMagicItemItemStackHandler inventory, int offset, String suffix) {
        int index = offset + inventory.getCompositeInventoryIndex();
        ItemStack itemStack = inventory.getStackInSlot(index);
        String name = itemStack.func_77973_b().getClass().getSimpleName();
        return name.endsWith(suffix);
    }

    boolean isPos1LegalSequence(CompositeMagicItemItemStackHandler inventory) {
        return this.isFirstItemProjectileFormation(inventory);
    }

    boolean isPos2LegalSequence(CompositeMagicItemItemStackHandler inventory) {
        boolean itemIsP = this.isSecondItemProjectile(inventory);
        boolean itemIsPFM = this.isSecondItemProjectileFormationModifier(inventory);
        if (itemIsP) {
            return true;
        }
        return itemIsPFM;
    }

    boolean isPos3LegalSequence(CompositeMagicItemItemStackHandler inventory) {
        if (this.isSecondItemProjectileFormationModifier(inventory)) {
            boolean itemIsP = this.isThirdItemProjectile(inventory);
            return itemIsP;
        }
        boolean itemIsPP = this.isThirdItemProjectilePath(inventory);
        boolean itemIsPM = this.isThirdItemProjectileModifier(inventory);
        if (itemIsPP) {
            return true;
        }
        return itemIsPM;
    }

    boolean isPos4LegalSequence(CompositeMagicItemItemStackHandler inventory) {
        if (this.isSecondItemProjectileFormationModifier(inventory)) {
            boolean itemIsPP = this.isFourthItemProjectilePath(inventory);
            boolean itemIsPM = this.isFourthItemProjectileModifier(inventory);
            if (itemIsPP) {
                return true;
            }
            return itemIsPM;
        }
        if (this.isThirdItemProjectilePath(inventory)) {
            boolean itemIsPP = this.isFourthItemProjectilePath(inventory);
            boolean itemIsPM = this.isFourthItemProjectileModifier(inventory);
            if (itemIsPP) {
                return true;
            }
            return itemIsPM;
        }
        boolean itemIsPM = this.isFourthItemProjectileModifier(inventory);
        return itemIsPM;
    }

    boolean isPos5LegalSequence(CompositeMagicItemItemStackHandler inventory) {
        if (this.isFourthItemProjectilePath(inventory)) {
            boolean itemIsPP = this.isFifthItemProjectilePath(inventory);
            boolean itemIsPM = this.isFifthItemProjectileModifier(inventory);
            if (itemIsPP) {
                return true;
            }
            return itemIsPM;
        }
        boolean itemIsPM = this.isFifthItemProjectileModifier(inventory);
        return itemIsPM;
    }

    boolean isPos6LegalSequence(CompositeMagicItemItemStackHandler inventory) {
        if (this.isFifthItemProjectilePath(inventory)) {
            boolean itemIsPP = this.isSixthItemProjectilePath(inventory);
            boolean itemIsPM = this.isSixthItemProjectileModifier(inventory);
            if (itemIsPP) {
                return true;
            }
            return itemIsPM;
        }
        boolean itemIsPM = this.isSixthItemProjectileModifier(inventory);
        return itemIsPM;
    }
}

