/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildRainbowRoad
implements BlockClickedItemAction {
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    private static final int MAX_ROAD_SEGMENTS = 8;
    static final int X_SIZE = 3;
    static final int Y_SIZE = 1;
    static final int Z_SIZE = 8;
    static final int X_OFFSET = -1;
    static final int Y_OFFSET_DOWN = -1;
    static final Structure NULL_STRUCTURE = new CompositeStructure();

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(pos.func_177956_o(), player);
        Structure structure = null;
        if (!isGroundBlock) {
            return DIDNT_USED_ITEM;
        }
        structure = this.createRoad();
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, player, structure, false);
        BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
        repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createRoad() {
        CompositeStructure composite = new CompositeStructure();
        int displacement = 0;
        for (int index = 0; index < 8; ++index) {
            displacement = this.calculateDisplacement(index, displacement);
            BlockPos offset = new BlockPos(displacement, -1, 8 * index);
            BlockPos size = new BlockPos(3, 1, 1);
            Block block = Blocks.field_196558_aN;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 1);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196566_aV;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 2);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196567_aW;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 3);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196559_aO;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 4);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196561_aQ;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 5);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196560_aP;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 6);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196557_aM;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, -1, 8 * index + 7);
            size = new BlockPos(3, 1, 1);
            block = Blocks.field_196570_aZ;
            composite.add(new ChildStructure(offset, size, block));
            offset = new BlockPos(displacement, 0, 8 * index);
            size = new BlockPos(4, 4, 8);
            composite.add(new ChildStructure(offset, size, Blocks.field_150350_a));
            BlockPos offsetLightpole = new BlockPos(offset.func_177958_n() - 1, -1, offset.func_177952_p());
            BlockPos sizeLightpole = new BlockPos(1, 1, 1);
            composite.add(new ChildStructure(offsetLightpole, sizeLightpole, Blocks.field_180407_aO));
            BlockPos offsetTorch = new BlockPos(offsetLightpole.func_177958_n(), offsetLightpole.func_177956_o() + sizeLightpole.func_177956_o(), offsetLightpole.func_177952_p());
            BlockPos sizeTorch = ModConstants.UNITY_BLOCK_SIZE;
            composite.add(new ChildStructure(offsetTorch, sizeTorch, Blocks.field_150478_aa));
        }
        return composite;
    }

    int calculateDisplacement(int index, int displacement) {
        if (index == 0) {
            return -1;
        }
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int displacementRandom = random.nextInt(3);
        if (displacementRandom == 1) {
            return displacement + 1;
        }
        if (displacementRandom == 2) {
            return displacement - 1;
        }
        return displacement;
    }
}

