/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CopyPasteBlocks
implements BlockClickedItemAction {
    public static final String NAME = CopyPasteBlocks.class.getSimpleName();
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    static final String MSG_COPIED = "Copied blocks.";
    static final String MSG_ILLEGAL_TRIGGER = "Illegal trigger. Click on a ground block to paste.";
    static final String MSG_RESET = "Reset captured blocks.";
    static final String MSG_REGISTERED_M1 = "Registered #1 marker. Click on another ground block to set the second marker.";
    static final String MSG_REGISTERED_M2 = "Registered #2 marker and captured blocks. Click on a ground block to paste. Click on a non-ground block to reset.";
    ParticleRenderingInfo info;
    static final Structure NULL_STRUCTURE = new CompositeStructure();
    static final int FIRST_INDEX = 0;
    StaffState state = StaffState.NO_MARKERS_DEFINED;
    BlockPos firstMarker;
    BlockPos secondMarker;
    boolean isActive = false;
    int rotationDegrees;
    List<BlockDirective> capturedBlocks;
    ParticleRendering firstMarkerParticle;
    ParticleRendering secondMarkerParticle;

    public CopyPasteBlocks() {
        this.info = ConfigUtils.createInfoFromConfig(ModConfiguration.copyPasteBlocksParticleInfo);
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        try {
            BlockPos pos = context.func_195995_a();
            PlayerEntity player = context.func_195999_j();
            Structure structure = this.updateState(pos, player);
            int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
            BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
            List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, player, structure, false);
            BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
            repository.addAll(directives);
            return USED_ITEM;
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            return DIDNT_USED_ITEM;
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure updateState(BlockPos targetBlockPosition, PlayerEntity player) {
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(targetBlockPosition.func_177956_o(), player);
        switch (this.state) {
            case NO_MARKERS_DEFINED: {
                if (!this.isLegaLFirstMarker(isGroundBlock)) {
                    return NULL_STRUCTURE;
                }
                this.state = StaffState.FIRST_MARKER_DEFINED;
                this.registerFirstMarker(targetBlockPosition, player);
                PlayerUtils.sendChatMessageToPlayer(player, MSG_REGISTERED_M1);
                return NULL_STRUCTURE;
            }
            case FIRST_MARKER_DEFINED: {
                if (!this.isLegaLSecondMarker(isGroundBlock, targetBlockPosition)) {
                    return NULL_STRUCTURE;
                }
                this.state = StaffState.SECOND_MARKER_DEFINED;
                this.registerSecondMarker(targetBlockPosition);
                this.captureWorldContent(player);
                PlayerUtils.sendChatMessageToPlayer(player, MSG_REGISTERED_M2);
                return NULL_STRUCTURE;
            }
            case SECOND_MARKER_DEFINED: {
                if (!this.isLegalTrigger(isGroundBlock, targetBlockPosition, player)) {
                    if (this.shouldReset(isGroundBlock)) {
                        this.state = StaffState.NO_MARKERS_DEFINED;
                        PlayerUtils.sendChatMessageToPlayer(player, MSG_RESET);
                        this.clearRendering();
                        return NULL_STRUCTURE;
                    }
                    PlayerUtils.sendChatMessageToPlayer(player, MSG_ILLEGAL_TRIGGER);
                    return NULL_STRUCTURE;
                }
                PlayerUtils.sendChatMessageToPlayer(player, MSG_COPIED);
                return this.getCapturedContent();
            }
        }
        return NULL_STRUCTURE;
    }

    boolean isLegaLFirstMarker(boolean isGroundBlock) {
        return isGroundBlock;
    }

    boolean isLegaLSecondMarker(boolean isGroundBlock, BlockPos pos) {
        if (!isGroundBlock) {
            return false;
        }
        BlockPos candidateMarker = pos;
        return !this.firstMarker.equals((Object)candidateMarker);
    }

    boolean isLegalTrigger(boolean isGroundBlock, BlockPos trigger, PlayerEntity player) {
        if (!isGroundBlock) {
            return false;
        }
        if (this.firstMarker.equals((Object)trigger)) {
            PlayerUtils.sendChatMessageToPlayer(player, "First marker isn't a legal target position.");
            return false;
        }
        if (this.secondMarker.equals((Object)trigger)) {
            PlayerUtils.sendChatMessageToPlayer(player, "Second marker isn't a legal target position.");
            return false;
        }
        return true;
    }

    boolean shouldReset(boolean isGroundBlock) {
        return !isGroundBlock;
    }

    void registerFirstMarker(BlockPos pos, PlayerEntity player) {
        this.firstMarker = pos;
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        if (playerDirection == PlayerDirection.East) {
            playerDirection = PlayerDirection.West;
        } else if (playerDirection == PlayerDirection.West) {
            playerDirection = PlayerDirection.East;
        }
        this.rotationDegrees = GeometryUtils.calculateDegreesFromPlayerDirection(playerDirection);
        this.firstMarkerParticle = DefaultParticleRendering.getInstance(pos, this.info);
        BassebombeCraft.getProxy().getNetworkChannel().sendAddParticleRenderingPacket(this.firstMarkerParticle);
    }

    void registerSecondMarker(BlockPos pos) {
        this.secondMarker = pos;
        this.secondMarkerParticle = DefaultParticleRendering.getInstance(pos, this.info);
        BassebombeCraft.getProxy().getNetworkChannel().sendAddParticleRenderingPacket(this.secondMarkerParticle);
    }

    void captureWorldContent(PlayerEntity player) {
        World world = player.func_130014_f_();
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos lower = this.calculateLowerBound();
        BlockPos upper = this.calculateUpperBound();
        BlockPos captureOffset = new BlockPos((Vec3i)lower);
        BlockPos captureSize = new BlockPos(upper.func_177958_n() - lower.func_177958_n(), upper.func_177956_o() - lower.func_177956_o(), upper.func_177952_p() - lower.func_177952_p());
        if (captureSize.func_177956_o() <= 0) {
            captureSize = new BlockPos(captureSize.func_177958_n(), 1, captureSize.func_177952_p());
        }
        this.capturedBlocks = GeometryUtils.captureRectangle(captureOffset, captureSize, world);
        BlockPos translation = this.calculateTranslationVector(captureOffset, captureSize, playerDirection);
        this.capturedBlocks = GeometryUtils.translate(translation, this.capturedBlocks);
    }

    BlockPos calculateLowerBound() {
        int x = 0;
        int y = 0;
        int z = 0;
        x = this.firstMarker.func_177958_n() < this.secondMarker.func_177958_n() ? this.firstMarker.func_177958_n() : this.secondMarker.func_177958_n();
        y = this.firstMarker.func_177956_o() < this.secondMarker.func_177956_o() ? this.firstMarker.func_177956_o() : this.secondMarker.func_177956_o();
        z = this.firstMarker.func_177952_p() < this.secondMarker.func_177952_p() ? this.firstMarker.func_177952_p() : this.secondMarker.func_177952_p();
        return new BlockPos(x + 1, y + 1, z + 1);
    }

    BlockPos calculateUpperBound() {
        int x = 0;
        int y = 0;
        int z = 0;
        x = this.firstMarker.func_177958_n() < this.secondMarker.func_177958_n() ? this.secondMarker.func_177958_n() : this.firstMarker.func_177958_n();
        y = this.firstMarker.func_177956_o() < this.secondMarker.func_177956_o() ? this.secondMarker.func_177956_o() : this.firstMarker.func_177956_o();
        z = this.firstMarker.func_177952_p() < this.secondMarker.func_177952_p() ? this.secondMarker.func_177952_p() : this.firstMarker.func_177952_p();
        return new BlockPos(x, y, z);
    }

    BlockPos calculateTranslationVector(BlockPos captureOffset, BlockPos captureSize, PlayerDirection playerDirection) {
        int translateX = captureOffset.func_177958_n();
        int translateY = captureOffset.func_177956_o();
        int translateZ = captureOffset.func_177952_p();
        switch (playerDirection) {
            case South: {
                return new BlockPos(translateX + captureSize.func_177958_n() - 1, translateY, translateZ);
            }
            case West: {
                return new BlockPos(translateX + captureSize.func_177958_n() - 1, translateY, translateZ + captureSize.func_177952_p() - 1);
            }
            case North: {
                return new BlockPos(translateX, translateY, translateZ + captureSize.func_177952_p() - 1);
            }
            case East: {
                return new BlockPos(translateX, translateY, translateZ);
            }
        }
        return new BlockPos(translateX, translateY, translateZ);
    }

    Structure getCapturedContent() {
        List<BlockDirective> rotatedBlocks = GeometryUtils.rotateCoordinatesAroundYAxisAtOrigin(this.rotationDegrees, this.capturedBlocks);
        return this.generateStructureForCapturedContent(rotatedBlocks);
    }

    Structure generateStructureForCapturedContent(List<BlockDirective> capturedBlocks) {
        BlockPos unitSize = new BlockPos(1, 1, 1);
        CompositeStructure composite = new CompositeStructure();
        for (BlockDirective directive : capturedBlocks) {
            ChildStructure child = new ChildStructure(directive.getBlockPosition(), unitSize, directive.getBlock(), directive.getState());
            composite.add(child);
        }
        return composite;
    }

    void clearRendering() {
        BassebombeCraft.getProxy().getNetworkChannel().sendRemoveParticleRenderingPacket(this.firstMarkerParticle);
        BassebombeCraft.getProxy().getNetworkChannel().sendRemoveParticleRenderingPacket(this.secondMarkerParticle);
    }

    static enum StaffState {
        NO_MARKERS_DEFINED,
        FIRST_MARKER_DEFINED,
        SECOND_MARKER_DEFINED;

    }
}

