/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.geom.WorldQueryImpl;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DuplicateBlock
implements BlockClickedItemAction {
    static final ActionResultType USED_ITEM = ActionResultType.SUCCESS;
    static final ActionResultType DIDNT_USED_ITEM = ActionResultType.PASS;
    static final int X_SIZE = 3;
    static final int Y_SIZE = 1;
    static final int Z_SIZE = 10;
    static final int X_OFFSET = -1;
    static final int Y_OFFSET_DOWN = 0;
    static final Structure NULL_STRUCTURE = new CompositeStructure();

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        WorldQueryImpl worldQuery = new WorldQueryImpl(player, pos);
        World world = context.func_195991_k();
        Block sourceBlock = BlockUtils.getBlockFromPosition(worldQuery.getTargetBlockPosition(), world);
        Structure structure = this.createDuplicatedBlock(sourceBlock, worldQuery);
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, player, structure, true);
        BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
        repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createDuplicatedBlock(Block sourceBlock, WorldQuery worldQuery) {
        CompositeStructure composite = new CompositeStructure();
        BlockPos blockPosition = worldQuery.getTargetBlockPosition();
        int yOffset = GeometryUtils.calculateYOffsetFromBlock(worldQuery.getPlayer(), blockPosition);
        BlockPos offset = new BlockPos(-1, yOffset, 0);
        BlockPos size = new BlockPos(2, 2, 2);
        if (this.createTntVariant()) {
            composite.add(new ChildStructure(offset, size, Blocks.field_150335_W));
            offset = new BlockPos(0, yOffset + 2, 0);
            size = new BlockPos(1, 1, 1);
            composite.add(new ChildStructure(offset, size, Blocks.field_150451_bX));
            return composite;
        }
        BlockState blockState = BlockUtils.getBlockStateFromPosition(blockPosition, worldQuery.getWorld());
        composite.add(new ChildStructure(offset, size, sourceBlock, blockState));
        return composite;
    }

    boolean createTntVariant() {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int randomValue = random.nextInt(25);
        return randomValue == 0;
    }
}

