/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.entity;

import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.Vec3d;

public class VacuumMist
implements EntityMistActionStrategy {
    public static final String NAME = VacuumMist.class.getSimpleName();
    ParticleRenderingInfo info = ConfigUtils.createInfoFromConfig(ModConfiguration.vacuumMistParticleInfo);
    int force;
    int duration = (Integer)ModConfiguration.vacuumMistDuration.get();

    public VacuumMist() {
        this.force = (Integer)ModConfiguration.vacuumMistForce.get();
    }

    @Override
    public void applyEffectToEntity(LivingEntity target, Vec3d mistPos, LivingEntity invoker) {
        Vec3d targetPosVec = target.func_174791_d();
        Vec3d pullVec = mistPos.func_178788_d(targetPosVec);
        pullVec = pullVec.func_72432_b();
        double x = pullVec.field_72450_a * (double)this.force;
        double y = pullVec.field_72448_b * (double)this.force;
        double z = pullVec.field_72449_c * (double)this.force;
        Vec3d motionVecForced = new Vec3d(x, y, z);
        target.func_213315_a(MoverType.SELF, motionVecForced);
    }

    @Override
    public int getEffectDuration() {
        return this.duration;
    }

    @Override
    public boolean isEffectAppliedToInvoker() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    public boolean isOneShootEffect() {
        return false;
    }

    @Override
    public int getEffectRange() {
        return 5;
    }

    @Override
    public ParticleRenderingInfo getRenderingInfos() {
        return this.info;
    }
}

