/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.composite;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ItemConfig;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.inventory.container.CompositeMagicItemCapabilityProvider;
import bassebombecraft.inventory.container.CompositeMagicItemContainerProvider;
import bassebombecraft.inventory.container.CompositeMagicItemItemStackHandler;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.world.WorldUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CompositeMagicItem
extends Item {
    public static final String NAME = CompositeMagicItem.class.getSimpleName();
    static final String BASE_NBT_TAG = "base";
    static final String CAPABILITY_NBT_TAG = "cap";
    Ports ports;
    int coolDown;
    String tooltip;

    public CompositeMagicItem() {
        this(ModConfiguration.compositeMagicItem);
    }

    public CompositeMagicItem(ItemConfig config) {
        super(new Item.Properties().func_200916_a(BassebombeCraft.getItemGroup()));
        this.coolDown = (Integer)config.cooldown.get();
        this.tooltip = (String)config.tooltip.get();
        this.ports = DefaultPorts.getInstance();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (WorldUtils.isLogicalClient(world)) {
            return super.func_77659_a(world, player, hand);
        }
        if (this.openGUI(player, hand)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
        }
        CooldownTracker tracker = player.func_184811_cZ();
        tracker.func_185145_a((Item)this, this.coolDown);
        ItemStack itemStack = player.func_184586_b(hand);
        CompositeMagicItemItemStackHandler inventory = CompositeMagicItem.getItemStackHandler(itemStack);
        String compositeName = this.createCompositeName(inventory);
        BassebombeCraft.getProxy().postItemUsage(compositeName, player.func_146103_bH().getName());
        Operator2 operator = inventory.getOperator();
        this.ports.setLivingEntity1((LivingEntity)player);
        this.ports.setWorld(world);
        Operators2.run(this.ports, operator);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    boolean openGUI(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return false;
        }
        if (!player.func_225608_bj_()) {
            return false;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        CompositeMagicItemContainerProvider provider = new CompositeMagicItemContainerProvider(itemStack);
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider);
        return true;
    }

    String createCompositeName(CompositeMagicItemItemStackHandler inventory) {
        StringBuilder name = new StringBuilder();
        name.append(this.getRegistryName().toString());
        name.append(inventory.getCompositeName());
        return name.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent text = new TranslationTextComponent(TextFormatting.GREEN + this.tooltip, new Object[0]);
        tooltip.add((ITextComponent)text);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CompositeMagicItemCapabilityProvider();
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbt) {
        if (nbt == null) {
            stack.func_77982_d(null);
            return;
        }
        CompoundNBT baseTag = nbt.func_74775_l(BASE_NBT_TAG);
        stack.func_77982_d(baseTag);
        CompoundNBT capabilityTag = nbt.func_74775_l(CAPABILITY_NBT_TAG);
        CompositeMagicItemItemStackHandler itemStackHandler = CompositeMagicItem.getItemStackHandler(stack);
        itemStackHandler.deserializeNBT(capabilityTag);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompositeMagicItemItemStackHandler itemStackHandler = CompositeMagicItem.getItemStackHandler(stack);
        CompoundNBT baseTag = stack.func_77978_p();
        CompoundNBT capabilityTag = itemStackHandler.serializeNBT();
        CompoundNBT combinedTag = new CompoundNBT();
        if (baseTag != null) {
            combinedTag.func_218657_a(BASE_NBT_TAG, (INBT)baseTag);
        }
        if (capabilityTag != null) {
            combinedTag.func_218657_a(CAPABILITY_NBT_TAG, (INBT)capabilityTag);
        }
        return combinedTag;
    }

    public static CompositeMagicItemItemStackHandler getItemStackHandler(ItemStack itemStack) {
        IItemHandler inventory = (IItemHandler)itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (inventory == null) {
            BassebombeCraft.getBassebombeCraft().reportAndLogError("Composite item did not have the expected ITEM_HANDLER_CAPABILITY");
            return new CompositeMagicItemItemStackHandler(1);
        }
        return (CompositeMagicItemItemStackHandler)inventory;
    }
}

