/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.network;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.effect.GraphicalEffectRepository;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.network.packet.AddCharm;
import bassebombecraft.network.packet.AddGraphicalEffect;
import bassebombecraft.network.packet.AddParticleRendering;
import bassebombecraft.network.packet.AddPotionEffect;
import bassebombecraft.network.packet.RemoveEffect;
import bassebombecraft.network.packet.RemoveParticleRendering;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkChannelHelper {
    static final ResourceLocation CHANNEL_NAME = new ResourceLocation("bassebombecraft", "main");
    static final String NETWORK_PROTOCOL_VERSION = "1";
    SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_NAME, () -> "1", "1"::equals, "1"::equals);

    public NetworkChannelHelper() {
        int msgIndex = 0;
        this.channel.registerMessage(msgIndex++, AddPotionEffect.class, AddPotionEffect::encode, AddPotionEffect::new, AddPotionEffect::handle);
        this.channel.registerMessage(msgIndex++, RemoveEffect.class, RemoveEffect::encode, RemoveEffect::new, RemoveEffect::handle);
        this.channel.registerMessage(msgIndex++, AddParticleRendering.class, AddParticleRendering::encode, AddParticleRendering::new, AddParticleRendering::handle);
        this.channel.registerMessage(msgIndex++, RemoveParticleRendering.class, RemoveParticleRendering::encode, RemoveParticleRendering::new, RemoveParticleRendering::handle);
        this.channel.registerMessage(msgIndex++, AddCharm.class, AddCharm::encode, AddCharm::new, AddCharm::handle);
        this.channel.registerMessage(msgIndex++, AddGraphicalEffect.class, AddGraphicalEffect::encode, AddGraphicalEffect::new, AddGraphicalEffect::handle);
    }

    public void sendAddPotionEffectPacket(LivingEntity entity, EffectInstance effectInstance) {
        try {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new AddPotionEffect(entity, effectInstance));
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void sendRemoveEffectPacket(LivingEntity entity, Effect effect) {
        try {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new RemoveEffect(entity, effect));
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void sendAddParticleRenderingPacket(ParticleRendering rendering) {
        try {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new AddParticleRendering(rendering));
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void sendRemoveParticleRenderingPacket(ParticleRendering rendering) {
        try {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new RemoveParticleRendering(rendering));
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void sendAddCharmPacket(MobEntity entity) {
        try {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new AddCharm(entity));
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void sendAddGraphicalEffectPacket(Entity source, Entity target, int duration, GraphicalEffectRepository.Effect effect) {
        try {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new AddGraphicalEffect(source, target, duration, effect));
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }
}

