/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.network.packet;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.particle.ParticleRenderingRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class AddParticleRendering {
    String id;
    BlockPos position;
    int duration;
    double speed;
    int number;
    float rgbRed;
    float rgbGreen;
    float rgbBlue;
    BasicParticleType type;

    public AddParticleRendering(PacketBuffer buf) {
        this.id = buf.func_218666_n();
        this.position = buf.func_179259_c();
        this.duration = buf.readInt();
        this.speed = buf.readDouble();
        this.number = buf.readInt();
        this.rgbRed = buf.readFloat();
        this.rgbGreen = buf.readFloat();
        this.rgbBlue = buf.readFloat();
        this.type = (BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.func_192575_l());
    }

    public AddParticleRendering(ParticleRendering rendering) {
        this.id = rendering.getId();
        this.position = rendering.getPosition();
        this.duration = rendering.getInfo().getDuration();
        this.speed = rendering.getInfo().getSpeed();
        this.number = rendering.getNumber();
        this.rgbRed = rendering.getInfo().getRedColorComponent();
        this.rgbGreen = rendering.getInfo().getGreenColorComponent();
        this.rgbBlue = rendering.getInfo().getBlueColorComponent();
        this.type = rendering.getInfo().getParticleType();
    }

    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.id);
        buf.func_179255_a(this.position);
        buf.writeInt(this.duration);
        buf.writeDouble(this.speed);
        buf.writeInt(this.number);
        buf.writeFloat(this.rgbRed);
        buf.writeFloat(this.rgbGreen);
        buf.writeFloat(this.rgbBlue);
        buf.func_192572_a(this.type.getRegistryName());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> this.handlePacket());
        ctx.setPacketHandled(true);
    }

    void handlePacket() {
        try {
            ParticleRenderingInfo info = DefaultParticleRenderingInfo.getInstance(this.type, this.number, this.duration, this.rgbRed, this.rgbGreen, this.rgbBlue, this.speed);
            ParticleRendering particle = DefaultParticleRendering.getInstance(this.position, info);
            ParticleRenderingRepository repository = BassebombeCraft.getProxy().getClientParticleRenderingRepository();
            repository.add(this.id, particle);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }
}

