/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.network.packet;

import bassebombecraft.BassebombeCraft;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.fml.network.NetworkEvent;

public class AddPotionEffect {
    int effectId;
    int duration;
    int amplifier;
    int entityId;

    public AddPotionEffect(PacketBuffer buf) {
        this.effectId = buf.readInt();
        this.entityId = buf.readInt();
        this.duration = buf.readInt();
        this.amplifier = buf.readInt();
    }

    public AddPotionEffect(LivingEntity entity, EffectInstance effectInstance) {
        this.entityId = entity.func_145782_y();
        this.effectId = Effect.func_188409_a((Effect)effectInstance.func_188419_a());
        this.duration = effectInstance.func_76459_b();
        this.amplifier = effectInstance.func_76458_c();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.effectId);
        buf.writeInt(this.entityId);
        buf.writeInt(this.duration);
        buf.writeInt(this.amplifier);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> this.handlePacket());
        ctx.setPacketHandled(true);
    }

    void handlePacket() {
        try {
            Minecraft mcClient = Minecraft.func_71410_x();
            Entity entity = mcClient.field_71441_e.func_73045_a(this.entityId);
            if (entity == null) {
                return;
            }
            Effect effect = Effect.func_188412_a((int)this.effectId);
            if (effect == null) {
                return;
            }
            EffectInstance effectInstance = new EffectInstance(effect, this.duration, this.amplifier);
            ((LivingEntity)entity).func_195064_c(effectInstance);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }
}

