/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplodeOnImpact2
implements Operator2 {
    public static final String NAME = ExplodeOnImpact2.class.getSimpleName();
    static final Entity NULL_ENTITY = null;
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, World> fnGetWorld;

    public ExplodeOnImpact2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, World> fnGetWorld) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetWorld = fnGetWorld;
    }

    public ExplodeOnImpact2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        BlockPos position;
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        if (ProjectileUtils.isEntityHit(result)) {
            if (!ProjectileUtils.isTypeEntityRayTraceResult(result)) {
                return;
            }
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            position = entity.func_180425_c();
            AxisAlignedBB aabb = entity.func_174813_aQ();
            float explosionRadius = (float)Math.max(aabb.func_216364_b(), aabb.func_216362_d());
            double minExplosionRadius = (Double)ModConfiguration.explodeMinExplosionRadius.get();
            explosionRadius = (float)Math.max((double)explosionRadius, minExplosionRadius);
            world.func_217385_a(entity, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), explosionRadius, Explosion.Mode.DESTROY);
        }
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            position = blockResult.func_216350_a();
            double minExplosionRadius = (Double)ModConfiguration.explodeMinExplosionRadius.get();
            world.func_217385_a(NULL_ENTITY, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), (float)minExplosionRadius, Explosion.Mode.DESTROY);
        }
    }
}

