/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpawnAnvil2
implements Operator2 {
    public static final String NAME = SpawnAnvil2.class.getSimpleName();
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, World> fnGetWorld;

    public SpawnAnvil2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, World> fnGetWorld) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetWorld = fnGetWorld;
    }

    public SpawnAnvil2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        if (ProjectileUtils.isEntityHit(result)) {
            if (!ProjectileUtils.isTypeEntityRayTraceResult(result)) {
                return;
            }
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            Vec3d posVec = entity.func_174791_d();
            float height = entity.func_213302_cg();
            double lx = posVec.field_72450_a;
            double ly = posVec.field_72448_b + (double)height + (double)((Integer)ModConfiguration.spawnAnvilOffset.get()).intValue();
            double lz = posVec.field_72449_c;
            BlockPos blockpos = new BlockPos(lx, ly, lz);
            BlockUtils.setTemporaryBlock(world, blockpos, Blocks.field_150467_bQ, (Integer)ModConfiguration.spawnAnvilDuration.get());
        }
    }
}

