/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.block.BlockUtils;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpawnSquid2
implements Operator2 {
    public static final String NAME = SpawnSquid2.class.getSimpleName();
    static final int Y_SPAWN_OFFSET = 2;
    static final float PITCH = 0.0f;
    static final float PARTIAL_TICKS = 1.0f;
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, World> fnGetWorld;

    public SpawnSquid2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, World> fnGetWorld) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetWorld = fnGetWorld;
    }

    public SpawnSquid2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        Entity entity;
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        Vec3d posVec = null;
        float yaw = 0.0f;
        if (ProjectileUtils.isEntityHit(result)) {
            if (!ProjectileUtils.isTypeEntityRayTraceResult(result)) {
                return;
            }
            entity = ((EntityRayTraceResult)result).func_216348_a();
            posVec = entity.func_174791_d();
            posVec = posVec.func_72441_c(0.0, (double)entity.func_213302_cg(), 0.0);
            yaw = entity.func_195046_g(1.0f);
        }
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            BlockPos spawnPosition = BlockUtils.calculatePosition(blockResult);
            posVec = new Vec3d((double)spawnPosition.func_177958_n(), (double)spawnPosition.func_177956_o(), (double)spawnPosition.func_177952_p());
        }
        entity = (SquidEntity)EntityType.field_200749_ao.func_200721_a(world);
        double lx = posVec.field_72450_a;
        double ly = posVec.field_72448_b + 2.0;
        double lz = posVec.field_72449_c;
        entity.func_70012_b(lx, ly, lz, yaw, 0.0f);
        world.func_217376_c(entity);
    }
}

