/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.potion;

import bassebombecraft.ModConstants;
import bassebombecraft.config.ConfigUtils;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class PotionUtils {
    public static void doCommonPotionInitialization(Potion potion, String name) {
        potion.setRegistryName(name.toLowerCase());
    }

    public static void doCommonEffectInitialization(Effect effect, String name) {
        effect.setRegistryName("bassebombecraft", name.toLowerCase());
    }

    public static Potion getInstance(String name, String path, Effect effect) {
        int duration = ConfigUtils.getInt(path + ".duration");
        int amplifier = ConfigUtils.getInt(path + ".amplifier");
        EffectInstance effectInstance = new EffectInstance(effect, duration, amplifier);
        String registryName = name.toLowerCase();
        Potion potion = new Potion(name, new EffectInstance[]{effectInstance});
        potion.setRegistryName("bassebombecraft", registryName);
        return potion;
    }

    public static void registerPotionRecipe(Potion basePotion, Item reagent, Potion targetPotion) {
        Ingredient baseItem = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)basePotion)});
        Ingredient reagantItem = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)reagent)});
        ItemStack out = net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)targetPotion);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(baseItem, reagantItem, out));
    }

    public static Optional<EffectInstance> getEffectIfActive(LivingEntity entity, Effect effect) {
        if (entity == null) {
            return Optional.empty();
        }
        Optional<EffectInstance> optEffect = Optional.ofNullable(entity.func_70660_b(effect));
        return optEffect;
    }

    public static boolean isAmplifierEffectActive(LivingEntity entity) {
        Optional<EffectInstance> optEffect = PotionUtils.getEffectIfActive(entity, ModConstants.AMPLIFIER_EFFECT);
        return optEffect.isPresent();
    }
}

