/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.build.BuildUtils;
import bassebombecraft.item.action.build.tower.StairsMaterial;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.structure.CompositeStructure;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpawnStairs
implements ProjectileAction {
    public static final String NAME = SpawnStairs.class.getSimpleName();
    int duration = (Integer)ModConfiguration.spawnStairsDuration.get();

    @Override
    public void execute(ThrowableEntity projectile, World world, RayTraceResult result) {
        if (!ProjectileUtils.isBlockHit(result)) {
            return;
        }
        if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
            return;
        }
        BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
        LivingEntity owner = projectile.func_85052_h();
        int yFeetPosition = EntityUtils.calculateEntityFeetPosititionAsInt(owner);
        BlockPos targetPosition = BlockUtils.calculatePosition(blockResult);
        int stairsHeight = Math.abs(yFeetPosition - targetPosition.func_177956_o()) + 1;
        BlockPos stairOffset = new BlockPos(0, -stairsHeight, 1 - stairsHeight);
        CompositeStructure composite = new CompositeStructure();
        BlockState state = (BlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH);
        StairsMaterial stairsMaterial = BuildUtils.createInstance(state, Blocks.field_150390_bg, Blocks.field_196696_di);
        BuildUtils.addSolidStairUp(stairsHeight, stairsMaterial, composite, stairOffset);
        PlayerDirection playerDirection = EntityUtils.getPlayerDirection(owner);
        BlockPos offset = targetPosition;
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, composite, false, world);
        for (BlockDirective directive : directives) {
            BlockUtils.setTemporaryBlock(directive, this.duration);
        }
    }
}

