/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.proxy;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.effect.GraphicalEffectRepository;
import bassebombecraft.client.event.rendering.particle.ParticleRenderingRepository;
import bassebombecraft.config.VersionUtils;
import bassebombecraft.entity.commander.DefaultMobCommanderRepository;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.block.DefaultBlockDirectiveRepository;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlockRepository;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.charm.ServerCharmedMobsRepository;
import bassebombecraft.event.duration.DefaultDurationRepository;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.event.entity.target.DefaultTargetRepository;
import bassebombecraft.event.entity.target.TargetRepository;
import bassebombecraft.event.entity.team.DefaultTeamRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.event.frequency.DefaultFrequencyRepository;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.job.DefaultJobReposiory;
import bassebombecraft.event.job.JobRepository;
import bassebombecraft.inventory.container.RegisteredContainers;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.network.NetworkChannelHelper;
import bassebombecraft.proxy.Proxy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;

public class ServerProxy
implements Proxy {
    FrequencyRepository frequencyRepository = DefaultFrequencyRepository.getInstance();
    DurationRepository durationRepository = DefaultDurationRepository.getInstance();
    JobRepository jobRepository = DefaultJobReposiory.getInstance();
    CharmedMobsRepository charmedMobsRepository = ServerCharmedMobsRepository.getInstance();
    BlockDirectivesRepository blockDirectivesRepository = DefaultBlockDirectiveRepository.getInstance();
    TemporaryBlockRepository tempBlockRepository = DefaultTemporaryBlockRepository.getInstance();
    MobCommanderRepository mobCommanderRepository = DefaultMobCommanderRepository.getInstance();
    TeamRepository teamRepository = DefaultTeamRepository.getInstance();
    TargetRepository targetRepository = DefaultTargetRepository.getInstance();
    NetworkChannelHelper networkHelper = new NetworkChannelHelper();

    @Override
    public void startAnalyticsSession() {
        try {
            Optional<MinecraftServer> optServer = BassebombeCraft.getBassebombeCraft().getServer();
            MinecraftServer server = optServer.get();
            String host = server.func_71211_k();
            if (host == null || host.isEmpty()) {
                host = "*";
            }
            String port = Integer.toString(server.func_71215_F());
            String owner = server.func_71214_G();
            if (owner == null || owner.isEmpty()) {
                owner = "N/A";
            }
            String name = host + ":" + port + ";" + owner + ";" + server.func_71273_Y();
            VersionUtils.startServerSession(name);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Initiating usage session failed with: " + ex.getMessage());
        }
    }

    @Override
    public void endAnalyticsSession() {
        try {
            Optional<MinecraftServer> optServer = BassebombeCraft.getBassebombeCraft().getServer();
            MinecraftServer server = optServer.get();
            String hostname = server.func_71211_k();
            VersionUtils.endServerSession(hostname);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Ending usage session failed with: " + ex.getMessage());
        }
    }

    @Override
    public void postItemUsage(String itemName, String user) {
        try {
            VersionUtils.postItemUsageEvent(user, itemName);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting usage failed with: " + ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public void postException(Throwable e) {
        try {
            VersionUtils.postException(this.getUser(), e);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting exception:" + e + " failed with: " + ex);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for original exception:" + sw);
            sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public void postError(String msg) {
        try {
            VersionUtils.postError(this.getUser(), msg);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting error:" + msg + " failed with: " + ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public void postAiObservation(String type, String observation) {
        try {
            VersionUtils.postAiObservation(this.getUser(), type, observation);
        }
        catch (Exception ex) {
            Logger logger = BassebombeCraft.getBassebombeCraft().getLogger();
            logger.error("Posting AI observation: failed with: " + ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            logger.error("Stack trace for posting exception:" + sw);
        }
    }

    @Override
    public String getUser() {
        return "N/A(user not available in server)";
    }

    @Override
    public void setupClientSideRendering() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported by server.");
    }

    @Override
    public NetworkChannelHelper getNetworkChannel() {
        return this.networkHelper;
    }

    @Override
    public FrequencyRepository getServerFrequencyRepository() {
        return this.frequencyRepository;
    }

    @Override
    public FrequencyRepository getClientFrequencyRepository() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported by server.");
    }

    @Override
    public DurationRepository getServerDurationRepository() {
        return this.durationRepository;
    }

    @Override
    public DurationRepository getClientDurationRepository() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported by server.");
    }

    @Override
    public JobRepository getServerJobRepository() {
        return this.jobRepository;
    }

    @Override
    public ParticleRenderingRepository getClientParticleRenderingRepository() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported by server.");
    }

    @Override
    public GraphicalEffectRepository getClientGraphicalEffectRepository() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported by server.");
    }

    @Override
    public CharmedMobsRepository getServerCharmedMobsRepository() {
        return this.charmedMobsRepository;
    }

    @Override
    public CharmedMobsRepository getClientCharmedMobsRepository() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported by server.");
    }

    @Override
    public BlockDirectivesRepository getServerBlockDirectivesRepository() {
        return this.blockDirectivesRepository;
    }

    @Override
    public TemporaryBlockRepository getServerTemporaryBlockRepository() {
        return this.tempBlockRepository;
    }

    @Override
    public MobCommanderRepository getServerMobCommanderRepository() {
        return this.mobCommanderRepository;
    }

    @Override
    public TeamRepository getServerTeamRepository() {
        return this.teamRepository;
    }

    @Override
    public TargetRepository getServerTargetRepository() {
        return this.targetRepository;
    }

    @Override
    public void doDeferredRegistration(IEventBus bus) {
        RegisteredContainers.CONTAINER_REGISTRY.register(bus);
        RegisteredItems.ITEMS_REGISTRY.register(bus);
    }
}

