/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.util.function;

import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.projectile.GenericCompositeProjectileEntity;
import bassebombecraft.operator.Ports;
import bassebombecraft.player.PlayerUtils;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class Predicates {
    static final Predicate<Entity> NULL_PREDICATE = p -> true;
    static Function<Ports, Predicate<Entity>> fnGetNullPredicate = p -> NULL_PREDICATE;

    public static Function<Ports, Predicate<Entity>> fnGetNullPredicate() {
        return fnGetNullPredicate;
    }

    public static Predicate<Entity> hasIdenticalIds(Entity e1) {
        return e2 -> PlayerUtils.hasIdenticalUniqueID(e1, e2);
    }

    public static Predicate<Entity> hasDifferentIds(Entity e1) {
        return e2 -> !PlayerUtils.hasIdenticalUniqueID(e1, e2);
    }

    public static Predicate<Entity> isntProjectileThrower(Entity e1) {
        return e2 -> {
            if (!EntityUtils.isType(e1, GenericCompositeProjectileEntity.class)) {
                return true;
            }
            GenericCompositeProjectileEntity projectile = (GenericCompositeProjectileEntity)e1;
            LivingEntity thrower = projectile.getThrower();
            return !PlayerUtils.hasIdenticalUniqueID((Entity)thrower, e2);
        };
    }
}

