/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.world;

import java.util.Optional;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldUtils {
    public static boolean isLogicalClient(World world) {
        return world.func_201670_d();
    }

    public static boolean isLogicalServer(World world) {
        return !world.func_201670_d();
    }

    public static boolean isLogicalClient(Entity entity) {
        return WorldUtils.isLogicalClient(entity.func_130014_f_());
    }

    public static boolean isLogicalServer(Entity entity) {
        return WorldUtils.isLogicalServer(entity.func_130014_f_());
    }

    public static boolean isTypeServerWorld(World world) {
        Optional<World> ow = Optional.ofNullable(world);
        if (ow.isPresent()) {
            return ow.get() instanceof World;
        }
        return false;
    }

    public static boolean isTypeClientWorld(World world) {
        Optional<World> ow = Optional.ofNullable(world);
        if (ow.isPresent()) {
            return ow.get() instanceof ClientWorld;
        }
        return false;
    }

    public static void addLightningAtBlockPos(World world, BlockPos pos) {
        LightningBoltEntity bolt = new LightningBoltEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
        WorldUtils.addLightning(bolt, world);
    }

    public static void addLightning(LightningBoltEntity entity, World world) {
        if (WorldUtils.isTypeServerWorld(world)) {
            ServerWorld serverWorld = (ServerWorld)world;
            serverWorld.func_217468_a(entity);
            return;
        }
        if (WorldUtils.isTypeClientWorld(world)) {
            ClientWorld serverWorld = (ClientWorld)world;
            serverWorld.func_217410_a(entity);
            return;
        }
    }
}

