/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.client.protocol;

import java.io.IOException;
import shadowed.org.apache.http.HttpEntity;
import shadowed.org.apache.http.HttpEntityEnclosingRequest;
import shadowed.org.apache.http.HttpException;
import shadowed.org.apache.http.HttpRequest;
import shadowed.org.apache.http.HttpRequestInterceptor;
import shadowed.org.apache.http.HttpVersion;
import shadowed.org.apache.http.ProtocolVersion;
import shadowed.org.apache.http.annotation.Contract;
import shadowed.org.apache.http.annotation.ThreadingBehavior;
import shadowed.org.apache.http.client.config.RequestConfig;
import shadowed.org.apache.http.client.protocol.HttpClientContext;
import shadowed.org.apache.http.protocol.HttpContext;
import shadowed.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

